#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
SLA-проверки direct.yandex.ru для аудиторов

Агрегаты над checks.direct.yandex.ru + checks_day.direct.yandex.ru - для
удобного контроля над нотификациями без перевыкладки скриптов
"""

import os
import sys
import argparse
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))
# direct.yandex.ru потому что direct.prod_SLA - невалидное имя для голема (а lowercase sla похоже на slb - где совсем другие проверки)
HOST='direct.yandex.ru'

FLAP = {'flaps_config': FlapOptions(stable=60*45, critical=60*60, boost=60*10)}

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

sla_check = copy.deepcopy(DEFAULT_CHECK)
# тикеты для аудиторов тоже вешаем на direct.yandex.ru - они так привыкли
sla_check['notifications'].append(
    NotificationOptions(template_name='startrek', template_kwargs=dict(queue='DIRECTALERTS', status=['CRIT']), description=u'тикеты для аудиторов'),
)
sla_check['ttl'] = 600*15
children = []
for svc in ['trace.audit-sla.web', 'trace.audit-sla.api']:
    children = [Child(host='direct_backs', group_type='CGROUP', service=svc)]
    # не выводим это на тв (tags), есть отдельный агрегат с общими проверками
    checks.append(host=HOST, children=children, service=svc, **hash_merge(sla_check, LOGIC_AND, {'tags':['direct.audit-sla']}))

## checks.direct
services = (
    'scripts.bsExportMaster.working',
    'direct.fresh_currency_rates.ppc',
    'scripts.moderateExportMaster.working',
    'direct.fresh_currency_rates.ppcdict',
)
prefix = 'checks'
for svc in services:
    c = Child(host=prefix + '.direct.yandex.ru', service=svc)
    checks.append(host=HOST, children=[c], service=prefix + '.' + svc, **hash_merge(CALLING_CHECK, FLAP))

## checks_day.direct
services = (
    'geobase4_data.age',
    'scripts.ppcCampAutoPrice.working',
    'direct.camp_auto_price.easy.max_age_day',
)
prefix = 'checks_day'
for svc in services:
    c = Child(host=prefix + '.direct.yandex.ru', service=svc)
    checks.append(host=HOST, children=[c], service=prefix + '.' + svc, **hash_merge(CALLING_CHECK, ONLY_DAY, FLAP))

#for svc in ['bsexport.queue_age.std_80']:
#    c = Child(host=prefix + '.direct.yandex.ru', service=svc)
#    checks.append(host=HOST, children=[c], service=prefix + '.' + svc, **hash_merge(DEFAULT_CHECK, ONLY_DAY, FLAP, {'ttl': 150, 'refresh_time': 30}))

checks.apply(dry_run=not args.apply, pretty=args.pretty)
