#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

with open('/etc/yandex-direct/direct-backing-services.yaml') as f:
    conf = yaml.load(f)

top_level_children = []
for service, service_conf in conf['backing_services'].items():
    if 'health-checks' in conf.get('ignore-features', []):
        continue
    
    health_checks = service_conf.get('health_checks', [])
    disasters = service_conf.get('disasters', [])

    children = []
    for child_host, child_svc in [x.split(':') for x in health_checks]:
        children.append(Child(host=child_host, service=child_svc))

    for disaster in disasters:
        alert_host, alert_service = disaster.get('alert').split(':')
        tags = get_disaster_tags(disaster)
        chld = [Child(host=alert_host, service=alert_service)]
        disaster_svc = '-'.join([service, alert_service, 'disaster'])
        checks.append(children=chld, tags=tags, host=HOST, service=disaster_svc)
        children.append(Child(host=HOST, service=disaster_svc))

    meta = {}
    url_num = 0
    for url in service_conf.get('info_urls', []):
        if not "urls" in meta:
            meta["urls"] = []

        url_num += 1
        if isinstance(url, str):
            url = {"url": url}
        if isinstance(url, dict):
            meta["urls"].append({
                "title": url.get("title", "url" + str(url_num)),
                "type": "yasm_alert",
                "url": url.get("url", "https://wiki.yandex-team.ru/jeri/apps-health/")
            })

    checks.append(children=children, host=HOST, service=service, meta=meta, ttl=SOLOMON_TTL, tags=['direct-baking-systems-health'])
    top_level_children.append(Child(host=HOST, service=service))

checks.append(children=top_level_children, host=HOST, service='apps-health', meta=meta, tags=['direct-birds-eye'])

### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
