#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
проверки общей инфраструктуры директа (бекапы, графит, zxzk, consul, autoadmin и тд)
"""

import os
import sys
import yaml
import json
import argparse
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))


### START мониторинги ppcback
## мониторинги сервисов конкретного инстанса ppcback'а
PPCBACK_LOGIC_OR = {x: 1*60*15 for x in [
    'zookeeper-ppc',
]}

## централизованные мониторинги, запускающиеся на ppcback (могут на всех сразу или под switchman, могут кроном или monrun - не важно)
PPCBACK_LOGIC_AND = {
    'zk-sync-consistency': 5*60*15, # интервал - 5 минут, NODATA после 15 неудачных попыток запуска
    'noc-mail-reader.working': 30*60*15, # notify не мониторим, там и так есть ttl на downtime-db
    'yd_herald.mon.directadmin.calls': 30*60*15, # мониторинг отсылки звонящих digest
    'dc-downtimes-parser.working': 15*60*15, # мониторим парсер infra.yandex-team.ru
    'trace-cron-updater': 10*60*15,
    'trace-get-configs': 10*60*15,
}

# мониторинги заводилок мониторингов по сырым событиям из аркадии
for svc in ['direct-apps-juggler', 'dt-sb-sched-mon', 'directadmin-make-juggler']:
    PPCBACK_LOGIC_AND[svc] = 10*60*15 # запускаются каждые 10 минут, 15 запусков до nodata (вдруг аркадия лежит долго)

for svc in ['dns-hosts', 'dt-monitoring-loadlogs', 'mysql_backup_complects']:
    PPCBACK_LOGIC_AND[svc] = 1800*5 # запускаются все с разными интервалами, но максимальный - 1800, пусть будет 5 запусков до NODATA


with open('/etc/yandex-direct/direct-apps.conf.yaml') as f:
    apps_conf = yaml.load(f)
for app, app_conf in apps_conf['apps'].items():
    if not 'conductor_vs_zk' in app_conf.get('ignore-features', []):
        PPCBACK_LOGIC_AND['conductor_vs_zk.' + app] = 1*60*15
    if not 'zk-vs-deb' in app_conf.get('ignore-features', []):
        PPCBACK_LOGIC_AND['limtest_zookeeper_vs_deb.' + app] = 1*60*15

def get_centralized_backstage_check(service_prefix, instance, **kwargs):
        service = service_prefix + '.' + instance
        child = Child(host='direct_backs', group_type='CGROUP', service=service)
        return dict(
            host=checks.aggr_host,
            service=service,
            children=[child],
            **hash_merge(DEFAULT_CHECK, LOGIC_AND, kwargs)
        )
### END мониторинги ppcback

CHILDREN = [
    'direct_autoadmin',
    'direct_ng_dom0_lxc',
    'direct_backs',
    'direct_logshatter_rtc',
    'zxzk',
]
CHILDREN = cgroups_to_children(CHILDREN)
def cc(suffixes):
    assert all([isinstance(x, str) for x in suffixes])
    children_subset = [x for x in CHILDREN if x['suffix'] in suffixes]
    return cgroups_to_children(children_subset)

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

FLAP_10_MIN = FlapOptions(stable=60*10, critical=60*30)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, children=CHILDREN, token=args.token)

checks.append_common()

CHILDREN_WO_AUTOADMIN = [x for x in CHILDREN if x['suffix'] not in ['direct_autoadmin', 'direct_logshatter_rtc']]
checks.append_walle(children=CHILDREN_WO_AUTOADMIN)

### проверка конфигов mysql
ALLDB_CONFIG = {}
with open('/etc/yandex-direct/alldb-config.json', 'r') as fh:
    ALLDB_CONFIG = json.load(fh)['instances']

for instance, value in ALLDB_CONFIG.items():
    if (value['project'] != 'direct' or value['type'] not in ['mysql', 'xtradb']):
        continue

    for service in ['gtid_consistency']:
        if instance in ['ppcdict-pxc', 'sandbox']:
            continue
        # ttl тут нужно ставить небольшой, свитчман может долго не запускать проверку на одном из хостов, хочется, чтобы он быстрее перешел в NODATA
        check_args=get_centralized_backstage_check(service, instance, ttl=60*3)
        check_args['tags'].append('mysql.' + instance)
        checks.append(**check_args)

    if value['auto_failover']['enabled']:
        for service in ['auto-failover.working', 'can_failover']:
       	    checks.append(**get_centralized_backstage_check(service, instance, ttl=60*3))

DB_CONFIG = {}
with open('/etc/yandex-direct/db-config.json', 'r') as fh:
    DB_CONFIG = json.load(fh)

for instance, value in DB_CONFIG['db_config']['CHILDS'].items():
    if value.get('engine', '') == 'zookeeper':
        checks.append(**get_centralized_backstage_check('zk_cluster_alive', instance))

### сервис-специфичные проверки
checks.append_aggr(children=cc(['direct_autoadmin']), service='gitmirror', **UNREACH_READY)
checks.append_aggr(children=cc(['direct_autoadmin']), service='sla-tickets', ttl=15*300, **hash_merge(UNREACH_READY, LOGIC_AND))
checks.append_aggr(children=cc(['direct_autoadmin']), service='sla-tickets-call', **hash_merge(UNREACH_READY, LOGIC_AND, CALLING_CHECK, ONLY_DAY))
for svc in ['logshatter-host']:
    checks.append_aggr(children=cc(['direct_logshatter_rtc']), service=svc, flaps_config=FLAP_10_MIN, **UNREACH_READY)

for svc, ttl in PPCBACK_LOGIC_OR.items():
    kwargs = {}
    checks.append_aggr(children=cc(['direct_backs']), service=svc, **hash_merge(kwargs, {'ttl': ttl}, UNREACH_READY))

for svc, ttl in PPCBACK_LOGIC_AND.items():
    kwargs = {}
    if svc.startswith('zookeeper_vs_deb'):
        kwargs = APPDUTY_CHECK
    checks.append_aggr(children=cc(['direct_backs']), service=svc, **hash_merge(kwargs, {'ttl': ttl}, UNREACH_READY, LOGIC_AND))

# TODO: сделать общие проверки про живость сервиса на риалах по vhosts-conf
checks.append_aggr(children=cc(['direct_backs']), service='juggler_history_alive', active='http', active_kwargs={'path': '/alive', 'headers': {'Host': 'juggler-history.da.yandex.ru'}}, **UNREACH_READY)

### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
