#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Весь прод директа (java + perl)
"""

import os
import sys
import argparse
import yaml
import json
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

FLAP_10_MIN = FlapOptions(stable=60*10, critical=60*30)

with open('/etc/yandex-direct/direct-apps.conf.yaml') as f:
    apps_conf = yaml.load(f)

PERL = apps_conf['apps']['direct']['conductor_groups']

JAVA = []
for app, app_conf in apps_conf['apps'].items():
    if app_conf['type'] == 'arcadia-java':
        JAVA += app_conf['conductor_groups']
JAVA = list(set(JAVA))
SSL = [
    'direct_frontends_sandbox',
]
DSCRIBE = [
    'direct_soap',
    'direct_frontends',
    'direct_intapi_rtc',
    'direct_scripts',
]
DSCRIBE_CHECKS = [
    'dscribe-upload-files.balance.working',
    'dscribe-upload-files.bsexport_prices.working',
    'dscribe-upload-files.dbshards_ids.working',
    'dscribe-upload-files.mediaplan.working',
    'dscribe-upload-files.messages.working',
    'dscribe-upload-files.moderate.working',
    'dscribe-upload-files.ppclog_api.working',
    'dscribe-upload-files.ppclog_cmd.working',
    'dscribe-upload-files.ppclog_price.working',
]

# PERL и JAVA могут пересекаться по sandbox
CHILDREN = list(set(PERL + JAVA))

def cc(cgroups_list, skip_subset_check=False):
    # это не всегда обязательно, но желательно, чтобы не заводить лишних проверок на пересекающиеся группы и не ломать зависимости между проверками
    assert skip_subset_check or set(cgroups_list).issubset(set(CHILDREN))
    return cgroups_to_children(cgroups_list)

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, children=cc(CHILDREN), token=args.token)

checks.append_common()

### сервис-специфичные проверки
#### direct_java
for svc in ['zk-delivery-ppc', 'zk-delivery-hooks-ppc']:
    checks.append_aggr(service=svc, **UNREACH_READY)

checks.append_aggr(
    children=cc([x for x in CHILDREN if x not in ['direct_frontends_sandbox']]),
    service='push-client',
    ttl=180*15,
    flaps_config=FlapOptions(stable=60*40, critical=60*60),
    **UNREACH_READY
)

checks.append_aggr(
    children=cc([x for x in CHILDREN if x not in ['direct_frontends_sandbox']]),
    service='push-client-working',
    ttl=180*15,
    flaps_config=FlapOptions(stable=60*40, critical=60*60),
    **UNREACH_READY
)

checks.append_aggr(children=cc(apps_conf['apps']['java-jobs']['conductor_groups']), service='java_jobs_old_processes', **UNREACH_READY)

#for svc in ['service_alive']:
    # TODO переделать на группы из apps-конфига
#    checks.append_aggr(children=cc(['direct_web_api_rtc']), service=svc, **UNREACH_READY)

for svc in ['dt-multitail-alive']:
    # TODO переделать на группы из apps-конфига
    checks.append_aggr(children=cc(['direct_intapi_rtc', 'direct_scripts']), service=svc, **UNREACH_READY)

for svc in ['process_vs_deb']:
    checks.append_aggr(service=svc, **hash_merge(APPDUTY_CHECK, UNREACH_READY))

for app, app_conf in apps_conf['apps'].items():
    if not 'zk-vs-deb' in app_conf.get('ignore-features', []):
        # временно пропускаем assert, потому что в CHILDREN группы не такие же, как в apps-конфиге
        # TODO привести в соответствие
        checks.append_aggr(children=cc(app_conf['conductor_groups'], skip_subset_check=True), service='zookeeper_vs_deb.%s' % app, **hash_merge({'ttl': 1*60*15}, APPDUTY_CHECK, UNREACH_READY))

for svc in ['vhost-consistency']:
    checks.append_aggr(service=svc, **UNREACH_READY)

#### direct_perl (real perl)
checks.append_aggr(children=cc(SSL), service='https_cert', **UNREACH_READY)

checks.append_aggr(children=cc(['direct_frontends', 'direct_soap', 'direct_intapi_rtc']), service='apache-mem', **UNREACH_READY)

# не хотим ли на всех машинках?
checks.append_aggr(children=cc(PERL), service='access_check', flaps_config=FlapOptions(stable=60*30, critical=60*120), **UNREACH_READY)

for svc in ['soap-alive-file-age']:
    checks.append_aggr(children=cc(['direct_soap', 'direct_frontends_sandbox']), service=svc, flaps_config=FLAP_10_MIN, **UNREACH_READY)

for svc in ['direct_alive']:
    checks.append_aggr(children=cc(['direct_frontends']), service=svc, flaps_config=FLAP_10_MIN, **UNREACH_READY)

checks.append_aggr(children=cc(PERL), service='dnssec', flaps_config=FLAP_10_MIN, **UNREACH_READY)
checks.append_aggr(children=cc(CHILDREN), service='check_mtu', flaps_config=FLAP_10_MIN, **UNREACH_READY)

with open('/etc/yandex-direct/db-config.json') as f:
    db_config = json.load(f)
SHARDS_NUM = len(db_config['db_config']['CHILDS']['ppc']['CHILDS'])
SHARDS = range(1, SHARDS_NUM + 1)

def create_checks_for_binlogbroker_json():
    dbs = ['ppc_%s' % sh for sh in SHARDS] + ['ppcdict']
    checks.append(
        host='direct.solomon-alert.binlogbroker-json',
        service='binlogbroker-json-lag',
        children=[Child(
                        host='direct.solomon-alert.binlogbroker-json-%s' % db,
                        group_type='HOST',
                        service='binlogbroker-json-lag'
                  ) for db in dbs]
    )
create_checks_for_binlogbroker_json()

# dscribe magic
# {'suffix': 'modlog', 'children': [{'host': 'mod_ng_mysql_modlog', 'group_type': 'CGROUP'}]}]
##dscribe_children = [{'suffix': 'phony', 'children': []}]
##for child in DSCRIBE:
##    dscribe_children[0]['children'].append({'host': child, 'group_type': 'CGROUP'})
##
##for svc in DSCRIBE_CHECKS:
##    checks.append_aggr_single(children=dscribe_children, service=svc, aggregator='more_than_limit_is_crit', **hash_merge(UNREACH_READY, {'aggregator_kwargs': {'percent': 10}}))

### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
