#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

with open('/etc/yandex-direct/direct-lifeline.yaml') as f:
    apps_conf = yaml.load(f)

top_level_children = []
for lifeline, lifeline_conf in apps_conf['lifeline'].items():
    if 'health-checks' in lifeline_conf.get('ignore-features', []):
        continue

    child_checks = lifeline_conf.get('health_checks', [])
    children = []
    for child_host, child_svc in [x.split(':') for x in child_checks]:
        children.append(Child(host=child_host, service=child_svc))

    meta = {}
    url_num = 0
    for url in lifeline_conf.get('info_urls', []):
        if not "urls" in meta:
            meta["urls"] = []

        url_num += 1
        if isinstance(url, str):
            url = {"url": url}
        if isinstance(url, dict):
            meta["urls"].append({
                "title": url.get("title", "url" + str(url_num)),
                "type": "yasm_alert",
                "url": url.get("url")
            })

    checks.append(children=children, host=HOST, service=lifeline, meta=meta, ttl=SOLOMON_TTL, tags=['direct-lifeline'])
    top_level_children.append(Child(host=HOST, service=lifeline))

checks.append(children=top_level_children, host=HOST, service='apps-lifeline', meta=meta, tags=['direct-lifeline-top'])

### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
