#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

services = [
    'ppcdata',
    'ppcmonitor',
    'sandbox',
]

children = []
for service in services:
    children.append(Child(host=HOST, service=service))

checks.append(children=children, host=HOST, service='mysql', tags=['direct-birds-eye'])
### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
