#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import argparse
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

# суффиксы для агрегации, для удобства совпадают с кондукторной группой и названием инстанса базы
CHILDREN = [
    'db_mdb2ktk8f8nilm6c8b8i', #ppcmonitor
#    'sandbox',
]

CHILDREN = cgroups_to_children(CHILDREN)

def cc(suffixes):
    assert all([isinstance(x, str) for x in suffixes])
    children_subset = [x for x in CHILDREN if x['suffix'] in suffixes]
    return cgroups_to_children(children_subset)

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

#добавляет ready_for_operation
checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, children=CHILDREN, token=args.token)
checks.append_common(checks=COMMON_CHECKS_MDB, skip_ready_for_operation=True)

#https://juggler.yandex-team.ru/aggregate_checks/?query=host%3Ddirect.prod_mysql
for svc in [ 'threads_connected_ppcmonitor', 'threads_running_ppcmonitor', 'freespace_ppcmonitor', 'mysql_slave_behind_ppcmonitor' ]:
    checks.append_aggr(children=[x for x in CHILDREN if x['suffix'] not in ['gorynych']], service=svc, **UNREACH_READY)

for child in CHILDREN:
    for svc in [ 'geo_position_master_ppcmonitor' ]:
        checks.append(host=HOST, service=svc)

### звонящие проверки
# после изменения желательно проделать пункты из
# https://wiki.yandex-team.ru/jeri/monitoring-alerting/#direkt-testirovaniezvonjashhixmonitoringovmysqlnaprimereppcdata
CHILDREN = [
    'ppcmonitor',
    'sandbox',
]
MDB = {
    'ppcmonitor': 'mdb2ktk8f8nilm6c8b8i',
    'sandbox': 'mdbl0tnt3rvjsc7k5j1h',
}
CHILDREN = cgroups_to_children(CHILDREN)

for instance in CHILDREN:
    service = 'db_availability' + '_trx_max_age_' + instance['suffix']
    child = Child(host='direct_backs', group_type='CGROUP', service=service)
    fixed_tags=DEFAULT_CHECK['tags'] + ['mysql.' + instance['suffix']]
    checks.append(
            host=checks.aggr_host,
            service=service,
            children=[child],
            tags=fixed_tags,
            **hash_merge(LOGIC_AND))


for instance in [x for x in CHILDREN if x['suffix'] != 'gorynych']:
    children = []

    services = [ 'db_availability' + '_host_alive_' + instance['suffix'],
		'db_availability' + '_fresh_slave_' + instance['suffix'],
                'db_availability' + '_read_only_' + instance['suffix'],
		'downtime-db.' + instance['suffix']
    ]
    dash_url = get_dashboard_url(name=instance['suffix'], cluster_id='mdb_' + MDB[instance['suffix']])

    for service in services:
        child = Child(host='direct_backs', group_type='CGROUP', service=service)
        params = hash_merge(CALLING_CHECK, LOGIC_AND)
        params['tags'].append('mysql.' + instance['suffix'])
        params['meta'] = dict(urls=[dash_url])
        checks.append(
            host=checks.aggr_host + '.call',
            service=service,
            children=[child],
            **params
        )

        children.append(Child(host=checks.aggr_host + '.call', service=service))

    meta = {
        "urls": [
            {
                "title": u"Визуализация схемы репликации",
                "type": "yasm_alert",
                "url": "https://obs.direct.yandex-team.ru/storages/get_replication_schema_graph?instance=%s" % instance['suffix']
            },
            dash_url,
         ]
    }

    checks.append(host=MYSQL_HEALTH_HOST, service=instance['suffix'], children=children, meta=meta, tags=['direct-mysql-health'])

for instance in ['gorynych', 'int-constructor']:
    #service = 'db_availability_' + instance
    services = [ 'db_availability' + '_host_alive_' + instance,
                'db_availability' + '_fresh_slave_' + instance,
                'db_availability' + '_read_only_' + instance,
    ]

    for service in services:
        child = Child(host='direct_backs', group_type='CGROUP', service=service)
        checks.append(
            host=checks.aggr_host + '.call',
            service=service,
            children=[child],
            **hash_merge(CALLS_CHAT_ONLY, LOGIC_AND, {
                'flaps_config': FlapOptions(stable=60*5, critical=60*25),
            })
        )


### применяем проверки
checks.apply(dry_run=not args.apply, pretty=args.pretty)
