#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import argparse
import json
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

with open('/etc/yandex-direct/db-config.json') as f:
    db_config = json.load(f)
SHARDS_NUM = len(db_config['db_config']['CHILDS']['ppc']['CHILDS'])

CHILDREN = []
CHILDREN_EXCLUDES_MDB = []

with open('/etc/yandex-direct/alldb-config.json') as f:
    alldb_config = json.load(f)
CHILDRENS_MDB = {}
for shard in range(1, SHARDS_NUM + 1):
    instance_name = 'ppcdata' + str(shard)
    CHILDRENS_MDB[instance_name] = alldb_config['instances'][instance_name]['mdb_cluster_id']

mdbshards = CHILDRENS_MDB.keys()

for shard in range(1, SHARDS_NUM + 1):
    shard = 'ppcdata' + str(shard)
    CHILDREN.append(shard)
    if shard not in mdbshards:
        CHILDREN_EXCLUDES_MDB.append(shard)

CHILDREN = cgroups_to_children(CHILDREN)
CHILDREN_EXCLUDES_MDB = cgroups_to_children(CHILDREN_EXCLUDES_MDB)

CHILDREN_ALL = cgroups_to_children(['db_' + id for id in CHILDRENS_MDB.values()])
#CHILDREN_ALL.extend(CHILDREN)

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

### tv проверки
checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, children=CHILDREN, token=args.token)

print CHILDREN
checks.append_common(checks=COMMON_CHECKS_MDB, rfo_children=CHILDREN_ALL, skip_ready_for_operation=True)
#checks.append_walle()

#checks.append_mysql(lfw_children=CHILDREN_EXCLUDES_MDB, zkguard_children=CHILDREN_EXCLUDES_MDB, skip_check_config=True)

# TODO: нужно перенести для всех баз, сделать звонящей
#checks.append_aggr(service='unispace.mission_critical', **UNREACH_READY)

for instance in CHILDREN:
    service = 'db_availability' + '_trx_max_age_' + instance['suffix']
    child = Child(host='direct_backs', group_type='CGROUP', service=service)
    fixed_tags=DEFAULT_CHECK['tags'] + ['mysql.' + instance['suffix']]
    checks.append(
            host=checks.aggr_host,
            service=service,
            children=[child],
            tags=fixed_tags,
            **hash_merge(LOGIC_AND))

#for svc in ['zk-delivery-ppc', 'zk-delivery-hooks-ppc']:
#    checks.append_aggr(service=svc, **UNREACH_READY)

#checks.append_aggr(
#    service='push-client',
#    ttl=180*15,
#    flaps_config=FlapOptions(stable=60*40, critical=60*60),
#    **UNREACH_READY
#)


# суффиксы для агрегации, для удобства совпадают с кондукторной группой и названием инстанса базы
for instance in CHILDRENS_MDB:
    child_mdb = cgroups_to_children(['db_' + CHILDRENS_MDB[instance]])

    mdbchecks = [ 'threads_connected_{0}'.format(instance),
                     'threads_running_{0}'.format(instance),
                     'freespace_{0}'.format(instance),
                     'mysql_slave_behind_{0}'.format(instance) ]

    meta = dict(urls=[get_dashboard_url(
        name=instance,
        cluster_id='m' + CHILDRENS_MDB[instance]
    )])
    fixed_tags= ['mysql.' + instance]
    fixed_tags.extend(DEFAULT_CHECK['tags']) # zero-diff-compatibility
    for svc in mdbchecks:
        checks.append_aggr(children=child_mdb, service=svc, **hash_merge(UNREACH_READY, dict(tags=fixed_tags, meta=meta)))

    mdbaggrchecks = [ 'geo_position_master_{0}'.format(instance) ]

    for svc in mdbaggrchecks:
        checks.append(host=HOST, service=svc, tags=fixed_tags, meta=meta)

### звонящие проверки
# после изменения желательно проделать пункты из
# https://wiki.yandex-team.ru/jeri/monitoring-alerting/#direkt-testirovaniezvonjashhixmonitoringovmysqlnaprimereppcdata
call_host = HOST + '.call'
top_level_children = []
WARDEN_TAGS = [
    'warden_alert_create_spi',
    'warden_alert_start_flow',
    'warden_auto_source',
    'warden_alert_category_boolean',
    'warden_functionality_direct_db-mysql_availability_ppcdata',
]
for shard in range(1, SHARDS_NUM + 1):
    children = []
    services = [ 'db_availability' + '_host_alive_ppcdata' + str(shard),
		'db_availability' + '_fresh_slave_ppcdata' + str(shard),
                'db_availability' + '_read_only_ppcdata' + str(shard),
		'downtime-db.ppcdata' + str(shard)
    ]
    for service in services:
        child = Child(host='direct_backs', group_type='CGROUP', service=service)
        check_params = hash_merge(CALLING_CHECK_MYSQL, LOGIC_AND)
        instance_name = 'ppcdata' + str(shard)
        check_params['tags'].append('mysql.' + instance_name)
        if any(substr in service for substr in ['_fresh_slave_', '_read_only_', '_host_alive_']):
            check_params['tags'].extend(WARDEN_TAGS)
            check_params['meta'] = {'urls': [
                {
                    'title': u'описание алерта',
                    'type': 'wiki',
                    'url': 'https://docs.yandex-team.ru/direct-dev/reference/alerts/ppcdata_availability'
                },
                get_dashboard_url(name=instance_name, cluster_id='m' + CHILDRENS_MDB[instance_name]),
            ]}
        checks.append(
            host=call_host,
            service=service,
            children=[child],
            **check_params
        )

        if service.startswith('db_availability_'):
            children.append(Child(host=call_host, service=service))

    meta = {
        "urls": [
            {
                "title": u"Визуализация схемы репликации",
                "type": "yasm_alert",
                "url": "https://obs.direct.yandex-team.ru/storages/get_replication_schema_graph?instance=ppcdata%d" % shard
            }
        ]
    }
    checks.append(host=MYSQL_HEALTH_HOST, service="ppcdata" + str(shard), children=children, meta=meta, tags=['direct-ppcdata-health'])
    top_level_children.append(Child(host=MYSQL_HEALTH_HOST, service="ppcdata" + str(shard)))

# для birds-eye-view
checks.append(host=MYSQL_HEALTH_HOST, service='ppcdata', children=top_level_children, tags=['direct-mysql-health'])

#aggr_host = HOST + '-hardware'
#aggr_kwargs = DEFAULT_CHECK #Вариант CALLING_CHECK
#aggr_kwargs = juggler_merge({'tags': ['direct-%s-health.' % HOST ]}, aggr_kwargs)
#aggr_kwargs['tags'] = [t for t in aggr_kwargs['tags'] if t != 'directadmin_TV']  # убираем с основоного tv-дашборда, там будут только общие проверки
#aggr_kwargs['ttl'] = SOLOMON_TTL

#children = []
#for k, i in {'threads': 'mysql-ppcdata%s-prod-threads-running'}:
#    for shard in range(1, SHARDS_NUM + 1):
#        children.append(Child(host='direct.solomon-alert', service='%s' % i))
#    checks.append(children=children, host=aggr_host, service='%s' % k, **aggr_kwargs)

#### применяем проверки
checks.apply(dry_run=not args.apply, pretty=args.pretty)
