#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

conf = """
resources:
  yt:
    type: yt
    env: prod
    clusters:
      "arnold":
        accounts: ["direct", "logfeller-direct", "adv"]
        mediums: ["default", "ssd_blobs", "ssd_journals"]
      "hahn":
        accounts: ["direct", "logfeller-direct", "adv"]
        mediums: ["default", "ssd_blobs", "ssd_journals"]
      "locke":
        accounts: ["direct"]
        mediums: ["default"]
      "markov":
        accounts: ["direct", "adv"]
        mediums: ["default"]
      "seneca-man":
        accounts: ["direct"]
        mediums: ["default", "ssd_blobs", "ssd_journals"]
      "seneca-sas":
        accounts: ["direct"]
        mediums: ["default", "ssd_blobs", "ssd_journals"]
      "seneca-vla":
        accounts: ["direct"]
        mediums: ["default", "ssd_blobs", "ssd_journals"]
      "bohr":
        accounts: ["adv"]
        mediums: ["ssd_blobs"]
      "landau":
        accounts: ["adv"]
        mediums: ["ssd_blobs"]
  yt-np:
    type: yt
    env: dev
    clusters:
      "arnold":
        accounts: ["direct-dev"]
        mediums: ["default"]
      "freud":
        accounts: ["direct", "logfeller-direct"]
        mediums: ["default"]
      "zeno":
        accounts: ["direct"]
        mediums: ["default", "ssd_blobs"]
"""

#with open('direct-resources.yaml') as f:
conf = yaml.load(conf)

for res_name, res_conf in [(k, v) for k, v in conf['resources'].items() if v['type'] == 'yt']:
    top_level_children = []

    aggr_host = HOST + '.' + res_name
    aggr_kwargs = CALLING_CHECK if res_conf['env'] == 'prod' else DEFAULT_CHECK
    aggr_kwargs = juggler_merge({'tags': ['direct-resources.' + res_name]}, aggr_kwargs)
    aggr_kwargs['tags'] = [t for t in aggr_kwargs['tags'] if t != 'directadmin_TV']  # убираем с основоного tv-дашборда, там будут только общие проверки
    aggr_kwargs['ttl'] = SOLOMON_TTL

    for yt_cluster, yt_conf in res_conf['clusters'].items():
        children = []
        for yt_account in yt_conf['accounts']:
            for yt_res in ['chunks-usage', 'nodes-usage', 'tablets-usage', 'chunks-usage-predicted', 'nodes-usage-predicted', 'tablets-usage-predicted']:
                if yt_res.endswith('-predicted') and (yt_cluster.startswith('seneca-') or yt_cluster.startswith('zeno')):
                    continue
                if yt_account == "logfeller-direct" and yt_res in ['tablets-usage', 'tablets-usage-predicted']:
                    continue
                children.append(Child(host='direct.solomon-alert.yt-%s.%s' % (yt_res, yt_cluster), service='account_%s' % (yt_account)))
            for medium in yt_conf['mediums']:
                for yt_res in ['mediums-usage', 'mediums-usage-predicted']:
                    if yt_res.endswith('-predicted') and (yt_cluster.startswith('seneca-') or yt_cluster.startswith('zeno')):
                        continue
                    if yt_cluster == "freud" and yt_account == "logfeller-direct" and medium != "default":
                        continue
                    if yt_account == "logfeller-direct" and medium in ['ssd_blobs', 'ssd_journals']:
                        continue
                    if yt_account == "adv" and yt_cluster == "markov" and medium != "default":
                        continue
                    children.append(Child(host='direct.solomon-alert.yt-%s.%s' % (yt_res, yt_cluster), service='account_%s.medium_%s' % (yt_account, medium)))

        meta = {"urls": []}
        for yt_account in yt_conf['accounts']:
            meta["urls"].append({
                "title": "YT %s:%s dashboard" % (yt_cluster, yt_account),
                "type": "yasm_alert",
                "url": "https://solomon.yandex-team.ru/?project=direct&service=accounts&dashboard=direct-yt-parametrized&cluster=%s&l.account=%s" % (yt_cluster, yt_account),
            })
        meta["urls"].append({
            "title": "YT monitorings wiki",
            "type": "yasm_alert",
            "url": "https://wiki.yandex-team.ru/jeri/yt-mon/",
        })
        checks.append(children=children, host=aggr_host, service=yt_cluster, meta=meta, **aggr_kwargs)
        top_level_children.append(Child(host=aggr_host, service=yt_cluster))

    checks.append(children=top_level_children, host=HOST, service=res_name, tags=['direct-resources-yt', 'direct-resources', 'direct-birds-eye'])

### logbroker-write-quota
lbwq_meta = {"urls":[{
    "type": "yasm_alert",
    "title": "alert description in docs",
    "url": "https://docs.yandex-team.ru/direct-dev/reference/alerts/logbroker-write-quota"
}]}
lbwq_host_prefix = "direct.solomon-alert.logbroker-write-quota-usage."
lbwq_service_prefix = "/Root/PersQueue/System/Quoters/"
checks.append(host=HOST, service="logbroker-write-quota", tags=['direct-resources'], meta=lbwq_meta, ttl=SOLOMON_TTL, children=[
    Child(lbwq_host_prefix + 'lbkx', lbwq_service_prefix + 'direct--cluster'),
    Child(lbwq_host_prefix + 'lbk', lbwq_service_prefix + 'direct--Vla'),
    Child(lbwq_host_prefix + 'lbk', lbwq_service_prefix + 'direct--Sas'),
    Child(lbwq_host_prefix + 'lbk', lbwq_service_prefix + 'direct--Iva'),
])
checks.append(host=HOST, service="logbroker-write-quota-np", tags=['direct-resources'], meta=lbwq_meta, ttl=SOLOMON_TTL, children=[
    Child(lbwq_host_prefix + 'lbkx', lbwq_service_prefix + 'direct-np--cluster'),
    Child(lbwq_host_prefix + 'lbkxt', lbwq_service_prefix + 'direct--cluster'),
    Child(lbwq_host_prefix + 'lbkp', lbwq_service_prefix + 'direct--Myt'),
    Child(lbwq_host_prefix + 'lbkp', lbwq_service_prefix + 'direct-test--Man'),
    Child(lbwq_host_prefix + 'lbkp', lbwq_service_prefix + 'direct-test--Myt'),
])
### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
