#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Проверки доступности балансеров
"""

import os
import sys
import argparse
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

# балансеры тут должны называться так же, как и в ppclogpusher:
# select distinct(vhost) from ppclogpusher.logs[_direct] where day=today() order by vhost;
# но не обязательно должны совпадать с названиями l3-балансеров и тем, куда ходят пользователи
# главное, чтобы соединение http/https проходило
BALANCERS = [
    ## direct
    {'slb_fqdn': 'direct.yandex.ru', 'https': True, 'call': True, 'health_checks': {'5xx_limit': 'direct.solomon-alert.clh-access-log:perl-front.5xx'}, 'in_yp': True, 'awacs_namespace': "direct.yandex.ru"},
    {'slb_fqdn': 'api.direct.yandex.ru', 'https': True, 'call': True, 'health_checks': {'5xx_limit': 'direct.solomon-alert.clh-access-log:perl-api.5xx'}, 'in_yp': True, 'awacs_namespace': "api.direct.yandex.ru"},
    {'slb_fqdn': 'intapi.direct.yandex.ru', 'https': True, 'call': True, 'health_checks': {'5xx_limit': 'direct.solomon-alert.clh-access-log:perl-intapi.5xx'}, 'in_yp': True, 'awacs_namespace': "intapi.direct.yandex.ru"},
    {'slb_fqdn': 'canvas-back.direct.yandex.net', 'https': False, 'call': True, 'in_yp': True, 'awacs_namespace': "canvas-back.direct.yandex.net"},#, 'health_checks': {'5xx_limit': 'direct.solomon-alert.clh-access-log:canvas.5xx'}},

    #{'slb_fqdn': 'java-api.direct.yandex.net', 'https': False, 'call': True, 'in_yp': True}, - уехало за один awacs балансер с perl-intapi
    {'slb_fqdn': 'java-intapi.direct.yandex.net', 'https': False, 'call': True, 'in_yp': True},
    {'slb_fqdn': 'java-logviewer.direct.yandex.net', 'https': False, 'call': True, 'in_yp': True, 'awacs_namespace': "direct-logviewer.yandex.net"},
    # у песочницы нет logpusher логов, забыли =(
    {'slb_fqdn': 'soap-sandbox.direct.yandex.ru', 'https': True, 'call': True, 'in_yp': False},

    ## advq
    #{'slb_fqdn': 'advquick-rt.yandex.ru', 'https': False, 'call': True},
    #{'slb_fqdn': 'advquick.yandex.ru', 'https': False, 'call': True},
    #{'slb_fqdn': 'advq.yandex.ru', 'https': True, 'call': True},
    #{'slb_fqdn': 'back.advq.yandex.ru', 'https': False, 'call': True},
    #{'slb_fqdn': 'forecast.advq.yandex.ru', 'https': False, 'call': True},
    #{'slb_fqdn': 'back-normal.advq.yandex.net', 'https': False, 'call': False},
    #{'slb_fqdn': 'back-normal-l3.advq.yandex.net', 'https': False, 'call': False},

    ## common infrastructure
    {'slb_fqdn': 'ppcgraphite.yandex.ru', 'https': True, 'call': True, 'awacs_namespace': "graphite_frontend_balancer"},
    {'slb_fqdn': 'ppcadmin.yandex-team.ru', 'https': False, 'call': False},

    ## gorynych, wordstat 
    {'slb_fqdn': 'gorynych.yandex.ru', 'https': True, 'awacs_namespace': "gorynych_frontend_balancer"},
    {'slb_fqdn': 'wordstat.yandex.ru', 'https': True, 'awacs_namespace': "wordstat.yandex.ru"},
    {'slb_fqdn': 'direct-pages-internal.yandex.net', 'https': False, 'awacs_namespace': "direct-pages-internal.yandex.net", 'skip_icmpping': True},
]

def append_slb(self, slb_fqdn, **kwargs):
    aggr = self.aggr_host + '.' + slb_fqdn

    call = kwargs.get('call', False)
    https = kwargs.get('https', False)
    in_yp = kwargs.get('in_yp', False)
    awacs = kwargs.get('awacs_namespace', False)

    # звонящий icmpping, когда сняли анонс с балансера
    svc = {'service': 'icmpping', 'active': 'icmpping'}
    child = Child(host=slb_fqdn, service=svc['service'])
    if not(slb.get('skip_icmpping')):
        if not call:
            self.append(host=aggr, children=[child], **hash_merge(self.default_check, svc))
        else:
            self.append(host=aggr, children=[child], **hash_merge(CALLING_CHECK, svc))

# пока очень шумные - убрал
#    if kwargs.get('health_checks'):
#        for aggr_svc, check in kwargs.get('health_checks').items():
#            host, service = check.split(':')
#            child = Child(host=host, service=service)
#            if not call:
#                self.append(host=aggr, service=aggr_svc, children=[child], **hash_merge(self.default_check, {'ttl': SOLOMON_TTL}))
#            else:
#                self.append(host=aggr, service=aggr_svc, children=[child], **hash_merge(CALLING_CHECK, {'ttl': SOLOMON_TTL}))

    if https:
        # https_cert (не звоним никогда)
        svc = {'service': 'https_cert', 'active': 'https_cert', 'active_kwargs': {'validate_hostname': True}}
        child = Child(host=slb_fqdn, service=svc['service'])
        self.append(host=aggr, children=[child], **hash_merge(self.default_check, svc))
# Мониторинг по балансерам и подам под ними
# для awacs не нужен, т. к. для них 1) список риалов обновляется автоматически, 2) скрипт dt-l3-yp.py, отправляющий события, для них не работает
    if in_yp and not awacs:
        svc = {'service': 'slb-yp_consistency', 'ttl': 60*2*60+60*15}
        child = Child(host=slb_fqdn, service=svc['service'])
        self.append(host=aggr, children=[child], **hash_merge(self.default_check, svc))

    if awacs:
        dcs = ['sas', 'man', 'vla']
        if awacs in ['api.direct.yandex.ru', 'intapi.direct.yandex.ru']:
            dcs = ['sas', 'iva', 'vla']
        elif awacs in ['direct.yandex.ru', 'canvas-back.direct.yandex.net', 'wordstat.yandex.ru']:
            dcs = ['sas', 'myt', 'vla']
        for response_type in ['400', '500']:
            svc = {'service': 'slb-l7-%s' % response_type}
            if awacs == 'intapi.direct.yandex.ru' and response_type == '500':   # DIRECT-143101 DIRECTADMIN-9633
                svc['flaps_config'] = FlapOptions(stable=30, critical=90)
            if awacs == 'api.direct.yandex.ru' and response_type == '500':   # DIRECT-151479
                svc['flaps_config'] = FlapOptions(stable=30, critical=90)
            child = Child(host='yasm_alert', service='direct-l7-%s.%s' % (response_type, awacs))  #Добавить l7-неймспейс, чтобы по нему отсылались события здесь https://yasm.yandex-team.ru/template/alert/direct-l7-500/
            self.append(host=aggr, children=[child], **hash_merge(self.default_check, svc))
        top_level_children = []
        svc = {'service': 'slb-l7-hw'}
        awacs_namespace_juggler_name = awacs.replace('_','-').replace('.','-')
        for check in ['cpu_wait_cores', 'mem_usage', 'cpu_usage', 'logs_vol_usage']:
            children = []
            for dc in dcs:
                children.append(Child(host='awacs.%s.%s' % (awacs_namespace_juggler_name, dc), service=check))
            self.append(host='direct.prod_slb.%s' % awacs_namespace_juggler_name, children=children, service=check) # не хотим поДЦшно смотреть, собираем агрегаты в 1 на каждую метричку
            top_level_children.append(Child(host='direct.prod_slb.%s' % awacs_namespace_juggler_name, service=check))# собираем детей из поДЦшных агрегатов
        self.append(host=aggr, children=top_level_children, **hash_merge(self.default_check, svc)) # - здесь получаются понеймспесовые(побалансерные) агрегаты

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)

for slb in BALANCERS:
    append_slb(checks, **slb)

checks.apply(dry_run=not args.apply, pretty=args.pretty)
