#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
"""

import os
import sys
import argparse
import yaml
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)

checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, token=args.token)
svc_to_check = {}

# файлы привозит пакет yandex-du-slbmon
tracemon_dir = '/var/lib/dt-tracemon/conf.d'
for fname in os.listdir(tracemon_dir):
    if not fname.endswith('.yaml'):
        continue
    with open("%s/%s" % (tracemon_dir, fname)) as f:
        conf = yaml.load(f)

    if conf['alert_name'] == 'web-all':
        continue

    children = [Child(host='direct_backs', service='trace.' + conf['alert_name'], group_type='CGROUP')]
    tracelog_services = sorted(list(set(x for x in conf['tracelog_services'].keys())))

    meta = {"urls": []}
    meta["urls"].append({
        "title": "methods_timings",
        "type": "yasm_alert",
        "url": "https://solomon.yandex-team.ru/?project=direct&cluster=ppcback&service=clh-trace&svc=%s&sensor=ela" % ("|".join(tracelog_services)),
    })
    meta["urls"].append({
        "title": "wiki",
        "type": "yasm_alert",
        "url": "https://wiki.yandex-team.ru/tracelog-methods-monitor",
    })

    check = dict(children=children, host=HOST, service='trace.' + conf['alert_name'], meta=meta,
                 ttl=conf['cron_params']['ttl'], **LOGIC_AND)

    if conf['alert_name'] in svc_to_check:
        if len(svc_to_check[conf['alert_name']]['tracelog_services']) < len(tracelog_services):
            svc_to_check[conf['alert_name']]['tracelog_services'] = tracelog_services
            svc_to_check[conf['alert_name']]['check'] = check
    else:
        svc_to_check[conf['alert_name']] = {'tracelog_services': tracelog_services, 'check': check}

for item in svc_to_check.values():
    checks.append(**item['check'])

### применяем проверки

checks.apply(dry_run=not args.apply, pretty=args.pretty)
