#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import argparse
from directadmon.directadmin_monitorings import *

### инициализация
(NAMESPACE, HOST) = get_namespace_host(os.path.basename(__file__))

def cc(suffixes):
    assert all([isinstance(x, str) for x in suffixes])
    children_subset = [x for x in CHILDREN if x['suffix'] in suffixes]
    return cgroups_to_children(children_subset)

parser = argparse.ArgumentParser()
add_default_args(parser)
args = parser.parse_args()
init_root_logger(args)


CHILDRENS_MDB = {
    'ppcdict': 'db_mdblik76kiv7nfcs498t', #ppcdict
}

INSTANCE_NAMES = cgroups_to_children(CHILDRENS_MDB.keys())
CHILDRENS = cgroups_to_children(CHILDRENS_MDB.values())

### tv проверки
checks = DirectAdminChecks(namespace=NAMESPACE, host=HOST, children=CHILDRENS, token=args.token)
checks.append_common(checks=COMMON_CHECKS_MDB, rfo_children=CHILDRENS, skip_ready_for_operation=True)


# суффиксы для агрегации, для удобства совпадают с кондукторной группой и названием инстанса базы
for instance in CHILDRENS_MDB:
        child_mdb = cgroups_to_children([CHILDRENS_MDB[instance]])

        mdbchecks = [ 'threads_connected_{0}'.format(instance),
                     'threads_running_{0}'.format(instance),
                     'freespace_{0}'.format(instance),
                     'mysql_slave_behind_{0}'.format(instance) ]

        fixed_tags= ['mysql.' + instance]
        fixed_tags.extend(DEFAULT_CHECK['tags']) # zero-diff-compatibility

        meta = dict(urls=[get_dashboard_url(
            name=instance,
            cluster_id='m' + CHILDRENS_MDB[instance]
        )])

        for svc in mdbchecks:
                checks.append_aggr(children=child_mdb, service=svc, **hash_merge(UNREACH_READY, dict(tags=fixed_tags, meta=meta)))
        mdbaggrchecks = [ 'geo_position_master_{0}'.format(instance) ]
        for svc in mdbaggrchecks:
                checks.append(host=HOST, service=svc, tags=fixed_tags, meta=meta)


for instance in [x for x in INSTANCE_NAMES]:
    service = 'db_availability' + '_trx_max_age_' + instance['suffix']
    child = Child(host='direct_backs', group_type='CGROUP', service=service)
    fixed_tags=DEFAULT_CHECK['tags'] + ['mysql.' + instance['suffix']]
    checks.append(
            host=checks.aggr_host,
            service=service,
            children=[child],
            tags=fixed_tags,
            **hash_merge(LOGIC_AND))


#checks.append_aggr(children=cc(['ppcdict']), ttl=300*15, service='mysql_wsrep_cnf_ppcdict', **UNREACH_READY) #COMMIT

WARDEN_TAGS = ['warden_alert_create_spi', 'warden_alert_start_flow', 'warden_auto_source', 'warden_functionality_direct_db-mysql_availability_ppcdict', 'warden_alert_category_boolean']
sre_tv_child = []
### звонящие проверки
# после изменения желательно проделать пункты из
# https://wiki.yandex-team.ru/jeri/monitoring-alerting/#direkt-testirovaniezvonjashhixmonitoringovmysqlnaprimereppcdata
for instance in [x for x in INSTANCE_NAMES]:
    services = [ 'db_availability' + '_host_alive_' + instance['suffix'],
                'db_availability' + '_fresh_slave_' + instance['suffix'],
                #'db_availability' + '_single_xtradb_' + instance['suffix'], #COMMIT
                'db_availability' + '_read_only_' + instance['suffix'],
                'db_availability' + '_semisync_master_' + instance['suffix'], #UNCOMMIT
                'db_availability' + '_semisync_slaves_' + instance['suffix'], #UNCOMMIT
                'downtime-db.' + instance['suffix']]

    for service in services:
        child = Child(host='direct_backs', group_type='CGROUP', service=service)
        check_params = hash_merge(CALLING_CHECK_MYSQL, LOGIC_AND)
        check_params['tags'].append('mysql.' + instance['suffix'])
        if service.startswith('db_availability_'):
            check_params['meta'] = dict(urls=[get_dashboard_url(
                name=instance['suffix'],
                cluster_id='m' + CHILDRENS_MDB[instance['suffix']]
            )])
            check_params['tags'].extend(WARDEN_TAGS)
            sre_tv_child.append(Child(host = checks.aggr_host + '.call', service = service))
            check_params['meta']['urls'].append({ 'title': u'описание алерта', 'type': 'wiki', 'url': 'https://docs.yandex-team.ru/direct-dev/reference/alerts/ppcdict_availability' })
        # if '_host_alive_' in service:
            # check_params['tags'].extend(['warden_alert_account_metric', 'warden_alert_metric_type_ydt'])
        checks.append(
            host=checks.aggr_host + '.call',
            service=service,
            children=[child],
            **check_params)

# для дашборда SRE (health)
checks.append(host=MYSQL_HEALTH_HOST, service='ppcdict', children=sre_tv_child, tags=['direct-mysql-health'])

#### применяем проверки
checks.apply(dry_run=not args.apply, pretty=args.pretty)
