#!/usr/bin/env perl

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :encoding(utf8));
use Encode qw(decode encode);
use Getopt::Long;
use Data::Dumper;
use Startrek::Client::Easy;

sub help {
    print "Скрипт для массового закрытия тикетов в DIRECTALERTS\n";
    print "Пример:\n";
    print "  Посмотреть все тикеты package inconsistency, по которым больше нет проблем:\n";
    print "  $0 --summary-regex='package inconsistency|has unknown yandex-direct version' --comment-regex='проблем не наблюдается'\n\n";
    print "  Закрыть все тикеты package inconsistency, по которым больше нет проблем:\n";
    print "  $0 --summary-regex='package inconsistency|has unknown yandex-direct version' --comment-regex='проблем не наблюдается' --close --close-with-comment 'Временные проблемы при выкладке релиза'\n";
    exit 0;
}

my $SUMMARY_RE = '';
my $COMMENT_RE = '';
my $CLOSE = '';
my $CLOSE_COMMENT = '';
my $FILTER = 'Queue: DIRECTALERTS and Resolution: empty()';

GetOptions(
    "filter=s" => \$FILTER,
    "summary-regex=s" => \$SUMMARY_RE,
    "comment-regex=s" => \$COMMENT_RE,
    "close!" => \$CLOSE,
    "close-with-comment=s" => \$CLOSE_COMMENT,
) || help();

$COMMENT_RE = decode('UTF-8', $COMMENT_RE, Encode::FB_CROAK);
$SUMMARY_RE = decode('UTF-8', $SUMMARY_RE, Encode::FB_CROAK);
$CLOSE_COMMENT = decode('UTF-8', $CLOSE_COMMENT, Encode::FB_CROAK);

help() if ! $SUMMARY_RE or ! $COMMENT_RE;

my $st = Startrek::Client::Easy->new();

for my $p (1 .. 100) {
    my $r = $st->get(query => $FILTER, page => $p, perPage => 100);
    last if ! $r || ! ref($r) eq 'LIST' || ! scalar(@$r);

    for my $t (@$r) {
        next if $t->{summary} !~ /$SUMMARY_RE/;

        my $comments = $st->request('GET', "/issues/$t->{key}/comments");
        next if ! $comments || ! ref($comments) eq 'LIST' || ! scalar(@$comments);

        my @c_sorted = sort { $a->{createdAt} cmp $b->{createdAt} } @$comments;
        my $last_comment = @c_sorted ? $c_sorted[-1]->{text} // "undef" : "undef";

        next if $last_comment !~ /$COMMENT_RE/;

        print "to close: $t->{key} $t->{summary}: $last_comment\n";

        if ($CLOSE && $CLOSE_COMMENT) {
            $st->do(key => $t->{key}, close => 1, comment => $CLOSE_COMMENT);
            print "closed: $t->{key} $t->{summary}: $last_comment\n";
        }
    }
}

