#!/usr/bin/python
# -*- encoding: utf-8 -*-

description = """
"""

import sys
import os

sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
from startrek_client import Startrek

import json
import re
import argparse
import subprocess

STARTREK_TOKEN_FILE = '~/.startrek_client_token'
SCRIPT_NAME = os.path.basename(__file__)


def parse_options():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    opts.extra = extra

    return opts


def run():
    opts = parse_options()

    startrek_token = open(os.path.expanduser(STARTREK_TOKEN_FILE)).readline().strip()
    startrek_client = Startrek(token=startrek_token, useragent=SCRIPT_NAME)

    for ticket in opts.extra:
        issue = startrek_client.issues[ticket]
        if issue.productionDate != None:
            print "SKIPPING %s" % ticket
            continue
        issue.update(productionDate=issue.sreEndTime)
        print "%s issue.productionDate := %s" % (ticket, issue.productionDate)


    return


if __name__ == '__main__':
    run()

