#!/usr/bin/python
# -*- coding: utf-8 -*-
# Скрипт выведет список пакетов, установленных на машине из "чужих" репозиториев (yandex-trusty, common, ...)
# mirror.yandex.ru "чужим" репозиторием не считается
# подробности: https://wiki.yandex-team.ru/jeri/no-common-deb-repos/

import re
import subprocess
import sys

p = subprocess.Popen(['dpkg-query', '--show', '--showformat', '${Package} ${Version}\n'], stdout=subprocess.PIPE)
for line in p.stdout:
    pkg, ver = line.rstrip().split(' ')
    out_lines = subprocess.check_output(['apt-cache', 'madison', pkg]).rstrip().split('\n')
    if not out_lines or not out_lines[0]:
        print pkg, 'NO_REPO'
        continue
    out_recs = [re.split(r'\s+\|?\s+', line.strip()) for line in out_lines]
    repos = [r[2] for r in out_recs if r[1] == ver]
    if len(repos):
        if len(filter(lambda x: re.match(r'http://(direct-trusty|direct-common|mirror)\.(dist\.)?yandex\.ru', x), repos)):
            pass
        else:
            print pkg, ver, ','.join(repos)
    else:
        print pkg, ver, 'NO_REPO'


