#!/usr/bin/python
# -*- coding: utf8 -*-


# Небольшой модуль с функциями (в основном для парсинга метаданных пакетов из репозиториев dist-а), подключаемый и используемый соседними скриптами 


import apt_pkg
import urllib2
import gzip
import StringIO


def get_path(repo, branch, arch):
    return 'http://'+repo+'.dist.yandex.ru/'+repo+'/'+branch+'/'+arch+'/Packages.gz'


def parse(f):
    data, tmp = [], ['', '', []]
    for line in f:
        s = line.split()
        if len(s) == 0:
            if tmp[0] != '':
                data.append(tmp)
                tmp = ['', '', []]
            continue
        if s[0] == 'Package:':
            tmp[0] = s[1]
        elif s[0] == 'Version:':
            tmp[1] = s[1]
        elif 'Depends' in s[0] or 'depends' in s[0]:
            # Depends, Pre-depends, etc.
            t = []
            # interpreting 'dep1 | dep2' as 'dep1, dep2'
            s = line.replace('|',',').replace(',',' ,').replace('(',' ').replace(')',' ').replace('<',' ').replace('>',' ').replace('=',' ').split()
            s[0] = ','
            s.append(',')
            for i in range(1, len(s)):
                if s[i] == ',':
                    if s[i - 2] == ',':
                        t.append((s[i - 1], ''))
                    else:
                        # => s[i - 3] == ','
                        t.append((s[i - 2], s[i - 1]))

            tmp[2] += t
        else:
            pass
    # just in case there's no newline in the eof
    if tmp[0] != '':
        data.append(tmp)

    return data


def get_parsed_data(path):
    # wrapping in StringIO because urlopen returns object that doesn't support some methods that gzip expects
    f_gz = StringIO.StringIO(urllib2.urlopen(path).read())
    f = gzip.GzipFile(mode='r', fileobj=f_gz)
    data = parse(f)
    # data has format: [ [package, version, [ (dependency, version) ]] ]
    return data


def pkg_cmp(p1, p2):
    # p_i == (package, version)
    if p1[0] < p2[0]:
        return -1
    elif p1[0] > p2[0]:
        return 1
    else:
        return apt_pkg.version_compare(p1[1], p2[1])
