#!/usr/bin/python
# -*- coding: utf8 -*-


import unittest
import os.path
import sys
dr = os.path.dirname(__file__)
sys.path.append(os.path.join(dr, '..', 'bin'))
import importlib
direct_dist_pkgdata = importlib.import_module('direct_dist_pkgdata')
direct_dist_check_dependencies = importlib.import_module('direct-dist-check-dependencies')
direct_dist_check_ext_dependencies = importlib.import_module('direct-dist-check-ext-dependencies')
import apt_pkg


def get_report(f):
    report = []
    for line in f:
        a = line.split()
        if len(a) == 0:
            continue
        if len(a) < 3:
            a.append('')
        report.append((a[0], (a[1], a[2])))
    return report


class TestCheckDependencies(unittest.TestCase):
    def test_report(self):
        ntests = 2
        for i in range(ntests):
            report = get_report(open(dr+'/tests/test'+str(i)+'/report'))
            data, branch = {}, 'stable'
            for br in direct_dist_check_dependencies.branches:
                data[br] = direct_dist_pkgdata.parse(open(dr+'/tests/test'+str(i)+'/'+br))
            apt_pkg.init()
            self.assertEqual(set(direct_dist_check_dependencies.check_dependencies(data, branch)), set(report))


class TestCheckExtDependencies(unittest.TestCase):
    def test_report(self):
        ntests = 1
        for i in range(ntests):
            report = get_report(open(dr+'/tests_ext/test'+str(i)+'/report'))
            data1 = direct_dist_pkgdata.parse(open(dr+'/tests_ext/test'+str(i)+'/r'))
            data2 = direct_dist_pkgdata.parse(open(dr+'/tests_ext/test'+str(i)+'/x'))
            apt_pkg.init()
            self.assertEqual(set(direct_dist_check_ext_dependencies.check_dependencies(data1, data2)), set(report))

