package Direct::ZKDowntime;

=head1 DESCRIPTION

    Работа с ожидаемыми даунтаймами, сохраненными в ZooKeeper в стиле Директа

=cut

use strict;
use warnings;

use utf8;

use Net::ZooKeeper;
use Time::Local;

our $ZK_HOSTS = ['ppcback01f.yandex.ru:2181', 'ppcback01i.yandex.ru:2181', 'ppcback01e.yandex.ru:2181',];
our $ZK_PREFIX = '/direct/hosts-downtimes';

our $ZKH;


=head2 downtime_check

    замена Yandex::Golem::downtime_check
    умеет возвращать несколько даунтаймов

    Проверить, есть ли (либо планируется) downtime для указанного хоста
    Возвращает ссылку на массив массивов вида [start, end] либо undef, если downtime не выставлен

=cut
sub downtime_check($) {
    my ($host) = @_;
        
    _connect_zookeeper();

    my @subnodes = $ZKH->get_children($ZK_PREFIX);
    die "can't get subnodes of $ZK_PREFIX ".$ZKH->str_error()."\n" if $ZKH->get_error();

    my $dt_data = '';
    for my $subnode ( @subnodes ) {
        if ($subnode eq $host){
            $dt_data = $ZKH->get("$ZK_PREFIX/$subnode");
            die "can't get content of $subnode: ".$ZKH->str_error()."\n" if $ZKH->get_error();
            last;
        }
    }

    my @result;
    for my $line (split /\n/, $dt_data){
        die "can't parse line:\n$line" unless $line =~ /([0-9]{4})-([0-9]{2})-([0-9]{2}) ([0-9]{2}):([0-9]{2}):([0-9]{2})/;
        my $time = timelocal($6,$5,$4,$3,$2-1,$1);
        push @result, [ $time, '-' ];
    }
    if ( scalar @result ){
        return \@result;
    } else {
        return undef;
    }
}



=head2 _connect_zookeeper

=cut
sub _connect_zookeeper
{
    return if $ZKH;
    die "empty \$ZK_HOSTS" unless scalar(@$ZK_HOSTS) > 0;
    my @errors;
    for (1..5) {
        my $rnd = int(rand(scalar(@$ZK_HOSTS)));
        my $zk_host = $ZK_HOSTS->[$rnd];
        $ZKH = Net::ZooKeeper->new($zk_host) or push @errors, "Error creating zkh object (host $zk_host): $!";
        if( $ZKH->exists("/") ){
            $ZKH->{data_read_len} = 10_000_000;
        }
    }
    die "can't connect to zookeeper: ".join("; ", @errors) if scalar @errors;
}

1;

