#!/usr/bin/perl

use common::sense;
use Yandex::Clickhouse;
$|++;

my $clh_f = Yandex::Clickhouse->new(
    host => 'ppchouse01f.yandex.ru',
);

my $clh_e = Yandex::Clickhouse->new(
    host => 'ppchouse01e.yandex.ru',
);

my $tables_f = $clh_f->query("show tables like '%201%'")->tsv();
# my $tables_f = [ map { [$_] } qw/ bsexport_data_201311 bsexport_data_201312 bsexport_prices_201311 bsexport_prices_201312 / ];
my $tables_e = $clh_e->query("show tables like '%201%'")->tsv();

my %tables;

for my $t (@$tables_f, @$tables_e) {
    $tables{$t->[0]}++;
}

for my $t (sort keys %tables) {
    my $cnt = $tables{$t};
    next unless $cnt == 2;

    my $cnt_f = $clh_f->get_one_field("select count() from $t");
    my $cnt_e = $clh_e->get_one_field("select count() from $t");
    printf("%s: %d (f) -- %d (e) : %s\n", $t, $cnt_f, $cnt_e, $cnt_f == $cnt_e ? 'ok' : '-------------error-------------');
}

__END__

# my $tables = $clh_f->query("show tables like '%201%'")->tsv();
for my $t (@$tables_f) {
    my $table = $t->[0];
    my $sql = $clh_f->get_one_field("show create table $table");
    if ($sql =~ /^create /i) {
        $sql =~ s!^create !ATTACH !i;
        print "$sql\n";
    }
    else {
        die "unexpected sql: $sql";
    }
    eval {
        $clh_e->query($sql);
    };
    warn $@ if $@;
    # last;
}
