#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Yandex::Clickhouse;
use YAML::XS;

my $t = shift or die "usage: $0 <table>\n";

my $clh = Yandex::Clickhouse->new(host => 'ppchouse01f.yandex.ru', port => 8123);
my $schema = $clh->query("desc $t")->tsv;
my $desc = {
    table_name => $t,
    table_fields => [
        map { { name => $_->[0], type => $_->[1] } } @$schema
    ],
};

print YAML::XS::Dump($desc);

