#!/usr/bin/perl

=head1 README

Скрипт для создания/переименования таблиц, переезд с merge на distributed

=cut

use common::sense;
use lib::abs '../lib';
use Yandex::Clickhouse;
use DScribe::ClickhouseTable;
use Getopt::Long;
use v5.12;

GetOptions(\my %opt,
    "host|h=s",
);

my $clh = Yandex::Clickhouse->new(
    host => $opt{host} // 'ppchouse01f.yandex.ru',
    port => 8123,
);

my $type = shift or die "usage: $0 <type>\n";

my $table = DScribe::ClickhouseTable->new($type);

my $cur_merge = $clh->query("show create table $type")->tsv()->[0]->[0];
#say $cur_merge;
if ($cur_merge =~ /ENGINE\s+=\s+Merge/) {
    say "table $type is Merge, renaming";
    $clh->query("rename table $type to ${type}_mergetree");
    say "creating new dist table";
    my $sql = $table->distr_table_schema_sql();
    #say $sql;
    $clh->query($sql);
}
elsif ($cur_merge =~ /ENGINE\s+=\s+Distributed/) {
    say "table $type is already Distributed";
}
else {
    die "unknown table engine";
}

__END__

Порядок переезда:
Удалить файлы с позициями:
aux/migr_type.bash dbshards_ids

Запустить заливку с новым конфигом, перезальются файлы за 23-25 число

Когда заливка отработает, имеем:
на 01f (старом):
Merge() и помесячные


на новом:
_mergetree (с данными)
помесячные (от старой заливки, не нужны)
dbshards_ids (распределенная)

на старом выполняем:
aux/migr_distr.pl dbshards_ids -h ppchouse01f
получаем:
_mergetree - объединяет помесячные
dbshards_ids - распределенная

На новом теперь можно удалить старые данные (помесячные таблицы)

В этом месте можно прописать новую строчку в кронтаб

После этого можно начинать удалять файлы стейта за 01-22 число, они начнут литься на новый сервер 
