#!/usr/bin/perl

use strict;
use warnings;
use utf8;
use lib::abs 'lib';
use YAML::XS;
use Getopt::Long;

do ''.lib::abs::path('../bin/dscribe-upload-files.pl') or die "...";

GetOptions(\my %opt,
    "from|f=s",
    "to|t=s",
    "writer|w=s",
    "parser|p=s",
    "config_from|config-from|cf=s",
    "config_to|config-to|ct=s",
);

my $conf_from = YAML::XS::LoadFile($opt{config_from});
my $conf_to   = YAML::XS::LoadFile($opt{config_to});

my $pos_from = get_pos_saver($opt{from}, writer => $opt{writer}, parser => $opt{parser}, conf => $conf_from->{positions});
my $pos_to   = get_pos_saver($opt{to},   writer => $opt{writer}, parser => $opt{parser}, conf => $conf_to->{positions});

my $iter = $pos_from->iter();

while (my $pos = $iter->()) {
    my $fn = $pos_to->get_norm_filename($pos->{filename});
    next unless $fn eq $pos->{filename}; # skip full paths
    $pos_to->write_position(
        $pos->{filename},
        $pos->{position},
        filesize => $pos->{filesize},
        complete => $pos->{complete},
    );
    print STDERR "$pos->{filename}\n";
}

