#!/usr/bin/perl

use common::sense;
use Path::Tiny;
use lib::abs '../lib';
use JSON;
use List::Util qw/shuffle/;
$|++;

my $ROOT = path(lib::abs::path('..'));

my $state_file = path($ROOT, "var/run", "reupload.json");

my $processed = {};
if ($state_file->is_file) {
    $processed = from_json($state_file->slurp_utf8);
}

my @json_files = grep { !is_processed($_) } find_json_pos_files(path($ROOT, "var/run/json-pos/"));


my $batch = 3;
my $time = 60;

while (@json_files) {
    printf "%d files to reupload\n", scalar @json_files;
    my $cnt = $batch;
    while ($cnt > 0) {
        $cnt--;
        my $f = shift @json_files;
        $f->remove();
        set_processed($f);
        print "remove $f\n";
    }
    sleep($time);
}

sub find_json_pos_files
{
    my ($dir) = @_;
    my @res;
    my $iter = $dir->iterator({ recurse => 1 });
    while (my $f = $iter->()) {
        if ($f =~ /201505(\d{2})/ && $1 >= 1 && $1 <= 22) {
            push @res, $f->absolute;
        }
    }
    return shuffle @res;
}

sub is_processed
{
    my $f = shift;
    return $processed->{$f};
}

sub set_processed
{
    my $f = shift;
    $processed->{$f} = 1;
    save_state_file();
}

sub save_state_file
{
    $state_file->spew_utf8(to_json($processed));
}
