#!/usr/bin/perl

use strict;
use warnings;

use Data::Dumper; 
use lib::abs '../lib';

unless (@ARGV == 1 && $ARGV[0] =~ /^\w+$/) {
    die "Usage: cat log | $0 parser_name";
}

my $name = $ARGV[0];
eval "require DScribe::Parser::$name";
my $parser = "DScribe::Parser::$name"->new(name => $name);

while(my $line = <STDIN>) {
    my $ret = $parser->parse_single_line($line);
    print Dumper {line => $line, ret => $ret};
}
