package DScribe::FilePositions;

use feature 'state';

use DBI;
use Data::Dumper;
use POSIX qw/strftime/;
use Sys::Hostname qw/hostname/;
use Log::Any qw/$log/;
use Data::Dump 'pp';

=head1 

пишет и читает позиции, до которых обработаны файлы логов

=cut


use Mouse;

has 'writer' => (is => 'ro', isa => 'Str', required => 1);
has 'parser' => (is => 'ro', isa => 'Str', required => 1);

sub BUILDARGS
{
    my ($self, %O) = @_;
    
    my $data = {
        writer => $O{writer},
        parser => $O{parser},
    };

    return $data;
}


=head2

    Параметры позиционные
    $filename -- имя файла (нормализованное)

=cut
sub read_position
{
    my $self = shift;
    my ($filename) = @_;

    my $res = $self->mass_read_position([$filename])->{$filename};

    return $res // {};
}

=head2 mass_read_position

    $files - ссылка на массив с нормализованными именами файлов
    возвращает хеш
        имя_файла => {
            position => ...,
            log_time => ...,
            filesize => ...,
            complete => 1|0,
            filename => ...,
        }

=cut

sub mass_read_position
{
    die 'not implemented';
}

=head2 

    Параметры позиционные
    $filename -- имя файла (полное)
    $pos -- позиция (результат tell)

    Далее -- параметры именованные:
    complete

    Возвращает ссылку на хеш (если позиций не нашлось -- ссылку на пустой хеш)

=cut

sub write_position
{
    die 'not implemented';
}

=head2 reset_position

Сбросить позицию для файла
    Параметры:
    $filename - имя файла (полное)

=cut

sub reset_position
{
    die 'not implemented';
}

=head2 is_complete

=cut

sub is_complete
{
    my ($self, $file) = @_;
    my $c = $self->mass_is_complete([$file])->{$file};
    $log->info("is_complete($file): $c");
    return $c
}

=head2 mass_is_complete

    $files - массив с не-нормализованными (полными) именами файлов
    возвращает хеш
        filename => 1 | 0

=cut

sub mass_is_complete
{
    my ($self, $files) = @_;
    my %norm2fn = map { $self->get_norm_filename($_) => $_ } @$files;
    my %sizes = map { $_ => (stat($_))[7]//0 } @$files;
    my $positions = $self->mass_read_position([ keys %norm2fn ]);
    if (@$files == 1) {
        $log->info("mass_is_complete: ".(pp [ $positions, \%sizes ]));
    }
    # если файл был обработан до конца и его размер не поменялся -- больше ничего с ним не делаем
    # ситуация, когда position > filesize (для gzip-ованных файлов) является нормальной
    # размер файла запоминается отдельно, просто для проверки что файл не изменился с прошлого запуска
    return { map {
        $norm2fn{$_} => (
            $positions->{$_}->{complete}
            && $positions->{$_}->{complete} == 1 
            && $positions->{$_}->{filesize} 
            && $positions->{$_}->{filesize} == $sizes{$norm2fn{$_}} 
        ? 1 : 0)
    } keys %norm2fn };
}

=head2 

    Параметры позиционные
    $file -- пусть к файлу (относительный или абсолютный, но важно, что с именем хоста внутри)

    возвращает "нормализованное" имя файла вида "хост/файл"

=cut
sub get_norm_filename
{
    my ($self, $file) = @_;

    $file =~ s!/ppcbackup\d+\w+!!g; # не пишем ppcbackup в source
    if ($file =~ m!\b((?:ppcscripts?|ci[0-9]|ppcsoap|limtest|ppcback)\w+)\b.*/([^/]+)$!) {
        my $host = $1;
        my $filename = $2;
        $filename =~ s/\.gz$//;
        my $norm_filename = "$host/$filename";
        return $norm_filename;
    }
    else {
        state $this_host = hostname();
        my $filename = $file =~ s!.*/!!r;
        $filename =~ s/\.gz$//;
        return "$this_host/$filename";
    }
    die "can not get norm filename for '$file";
}

1;

