package DScribe::Grep::Utils;


use strict;
use warnings;
use open ':std' => ':utf8';
use feature 'state';
use List::Util qw/first/;
use Path::Tiny;

sub list_known_tables
{
    my $dir = descriptions_dir();
    state $files = [ sort map { $_->basename =~ s!\.ya?ml$!!gr } path($dir)->children ];
    return @$files;
}

sub descriptions_dir
{
    my $dir = first { -d } (
        lib::abs::path('../../../..').'/share/dscribe/clickhouse_tables/',
        lib::abs::path('../../..').'/share/dscribe/clickhouse_tables/',
        lib::abs::path('../..').'/share/dscribe/clickhouse_tables/',
        lib::abs::path('..').'/share/dscribe/clickhouse_tables/',
        '/usr/local/share/dscribe/clickhouse_tables/',
    );
    unless ($dir) {
        die "failed to find schema dir";
    }
    return $dir;
}

1;
