package DScribe::Parser::balance;

use Time::Local;
use JSON;
use Yandex::HashUtils qw/hash_merge/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2

<134>1 2015-08-25T13:54:04+03:00 ppcdev1.yandex.ru beta_icenine_8502.balance_calls.log 564083 - - [pid=564083,reqid=6649929344820130528,method=Balance.FindClient,             data_type=response] [{"ClientID":"5299008"}]

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    my $h = $self->parse_syslog_line($line);

    if (@{$h->{error}||[]}) {
        $h->{group} = '';
        $h->{rec} = [];
        return $h;
    }

    if (!@{$h->{rec}}) {
        $h->{group} = '';
        return $h;
    }
    
    for my $rec (@{$h->{rec}||[]}) {
        next if $rec->{data} =~ /^(Balance.CreateClient fault|Balance.\w+ died - 500|Balance.\w+ fault|create_new_client_balance: save ClientID)/;
        my ($metadata, $json) = ($rec->{data} =~ m!^\[ ( (?:\S+ = \S+,?)* ) \]\s+(.*)!x);

        unless ($metadata && $json) {
            print STDERR "failed to parse data '$rec->{data}'\n";
            next;
        }

        my $data = eval { $self->json->decode($json) };
        if ($@) {
            push @{$h->{error}}, "can not parse line '$line'\njson '$json'\n$@\n";
            %$rec = ();
            next;
        }
        my $meta = eval { $self->parse_metadata_str($metadata) };
        if ($@) {
            push @{$h->{error}}, $@;
            %$rec = ();
            next;
        }
        hash_merge $rec, $meta;
        $rec->{proc_id} = delete $rec->{pid};

        $rec->{param} = $self->json->encode($data);
    }

    return $h;
}

1;



