package DScribe::Parser::bsimport_active_orders;

use Yandex::Validate qw/is_valid_id/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2 

=cut

sub parse_single_line
{
    my ($self, $line, %O) = @_;

    if ($line =~ m/^\{/) {
        # новый формат, данные пачками, в json

        my $data = eval { $self->json->decode($line); };
        if (!$data) {
            return {
                rec => [],
                error => ["Can't parse line: $@ ($line)"],
            };
        }

        my $rec_base = {
            log_date => [split / /, $data->{log_time}]->[0],
            log_time => $data->{log_time},
        };

        my @recs;
        for my $d (@{$data->{data}}) {
            push @recs, {
                %$rec_base,
                order_id => int( $d->{OrderID} ),
                stop => int( $d->{Stop} ),
                shows => int( $d->{Shows} ),
                clicks => int( $d->{Clicks} ),
                micro_cost => int( $d->{Cost} * 10e6 ),
                micro_cost_cur => int ( $d->{CostCur} * 10e6 ),
                update_time => $d->{UpdateTime},
            };
        }

        return {
            rec => \@recs,
            error => [],
        };
    } elsif ($line =~ m!
                      ^  (?<_date>[0-9]{4}-[0-9]{2}-[0-9]{2})
                      \t (?<_time>[0-9]{2}:[0-9]{2}:[0-9]{2})
                      \t (?<OrderID>[0-9]+)
                      (?:\t|/t) (?<Stop>[01])
                      (?:\t|/t) (?<Shows>[0-9]+)
                      (?:\t|/t) (?<Clicks>[0-9]+)
                      (?:\t|/t) (?<Cost>[0-9]+\.[0-9]+)
                      (?:\t|/t) (?<CostCur>[0-9]+\.[0-9]+)
                      (?:\t|/t) (?<UpdateTime>[0-9]{4}-[0-9]{2}-[0-9]{2}\N{U+0020}[0-9]{2}:[0-9]{2}:[0-9]{2})
                      $!x
    ) {
        # date time OrderID Stop Shows Clicks Cost CostCur UpdateTime
        # старый формат (tsv), c 2014-09-25
        # старый формат (tsv) со сломанной табуляцией (2014-09-03 - 2014-09-25):

        my %rec;
        $rec{log_date} = $+{_date};
        $rec{log_time} = "$+{_date} $+{_time}";
        $rec{order_id} = int( $+{OrderID} );
        $rec{stop} = int( $+{Stop} );
        $rec{shows} = int( $+{Shows} );
        $rec{clicks} = int( $+{Clicks} );
        $rec{micro_cost} = int( $+{Cost} * 10e6 );
        $rec{micro_cost_cur} = int( $+{CostCur} * 10e6 );
        $rec{update_time} = $+{UpdateTime};
        
        return {
            rec => [\%rec],
            error => [],
        };
    } else {
        return {
            rec => [],
            error => ["can't parse line ($line)"],
        };
    }
}

1;

