package DScribe::Parser::campaign_balance;

use Time::Local;
use JSON;
use Yandex::Validate qw/is_valid_id/;
use Yandex::HashUtils qw/hash_map hash_merge/;
use Yandex::ListUtils qw/as_array/;
use List::MoreUtils qw/uniq/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2 

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    my $h = $self->parse_json_line($line);

    # Если при разборе строки ошибки -- ничего разумного не пытаемся делать
    if (@{$h->{error}||[]}){
        $h->{group} = '';
        $h->{rec} = [];
        return $h;
    }

    if ( !@{$h->{rec}} ){
        $h->{group} = '';
        return $h;
    }

    for my $rec ( @{$h->{rec}||[]} ){
        my $data = delete $rec->{data};

        for my $f (qw/service method ip/) {
            $rec->{$f} = $data->{$f} // '';
        }
        $rec->{host} = $data->{log_hostname};
        $rec->{reqid} = int($data->{reqid});
        
        my $camp = $data->{data};
        $rec->{cid} = int($camp->{cid});
        for my $f (qw/type currency tid/) {
            $rec->{$f} = $camp->{$f} // '';
        }
        for my $f (qw/sum sum_balance sum_delta/) {
            $rec->{$f} = int(1_000_000 * $camp->{$f} + 0.5);
        }
        $rec->{ClientID} = int($camp->{ClientID});
    }

    return $h;
}

1;


