package DScribe::Parser::dbshards_ids;

use Time::Local;
use JSON;

use Mouse;

extends "DScribe::Parser::base_direct_log";


=head2 

{
    error => ["", "",],
    group => "12345",
    rec => [ {...}, {} ],
}

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    if ($line =~ /^</) {
        my $h = $self->parse_syslog_json_line($line);

        # Если при разборе строки ошибки -- ничего разумного не пытаемся делать
        if (@{$h->{error}||[]}){
            $h->{group} = '';
            $h->{rec} = [];
            return $h;
        }

        if ( !@{$h->{rec}} ){
            $h->{group} = '';
            return $h;
        }

        for my $rec ( @{$h->{rec}||[]} ){
            my $data = delete $rec->{data};
            $rec->{$_} = $data->{$_} for qw/ids key cnt reqid/;
            $rec->{insert_data} = $self->json->encode($data->{insert_data});
        }
        return $h;
    } else {
        my $data = eval { $self->json->decode($line); };
        if (!$data) {
            return {
                rec => [],
                error => ["Can't parse json-data: $@ ($line)"],
            };
        }
        my ($datetime, $date) = _parse_datetime_messages($data->{log_time});
        unless ($datetime) {
            return {
                rec => [],
                error => "can't parse datetime '$data->{log_time}' ($line)",
            };
        }
        return {
            rec => [
                {
                    log_time => $datetime, 
                    log_date => $date,
                    cnt => 1,
                    (map {$_ => $data->{$_}} qw/host ids key reqid/),
                    insert_data => $self->json->encode($data->{insert_data}),
                }
                ],
            error => [],
        };
    }
}

sub _parse_datetime_messages
{
    my $datetime_messages = shift;
    if ($datetime_messages && $datetime_messages =~ /(\d{4})-(\d{2})-(\d{2}):(\d{2}):(\d{2}):(\d{2})/) {
        my $datetime = "$1-$2-$3 $4:$5:$6";
        my $date = "$1-$2-$3";
        return '' unless eval { timelocal( $6, $5, $4, $3, $2-1, $1-1900) };
        return ($datetime, $date);
    } else {
        return '';
    }
}

1;

