package DScribe::Parser::mediaplan;

use Time::Local;
use JSON;

use Mouse;

extends "DScribe::Parser::base_direct_log";


=head2 

Опции именованные:
    group_by => 'month' ( не используется )

{
    error => ["", "",],
    group => "12345",
    rec => [ {...}, {} ],
}

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    my $h = $self->parse_syslog_json_line($line);

    # Если при разборе строки ошибки -- ничего разумного не пытаемся делать
    if (@{$h->{error}||[]}){
        $h->{group} = '';
        $h->{rec} = [];
        return $h;
    }

    if ( !@{$h->{rec}} ){
        $h->{group} = '';
        return $h;
    }

    for my $rec ( @{$h->{rec}||[]} ){
        my $data = delete $rec->{data};
        $rec->{$_} = $data->{$_} for qw/cid action/;
        $rec->{reqid} = $data->{reqid} // 0;
        $rec->{values} = to_json($data->{values});
    }
    
    return $h;
}


1;

