package DScribe::Parser::moderate;

use Time::Local;
use JSON;
use Yandex::Validate qw/is_valid_id/;
use Yandex::HashUtils qw/hash_map hash_merge/;
use Yandex::ListUtils qw/as_array/;
use List::MoreUtils qw/uniq/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2 

Опции именованные:
    group_by => 'month' ( не используется )

{
    error => ["", "",],
    group => "12345",
    rec => [ {...}, {} ],
}

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;
    my $h = $self->parse_bsexport_line($line);
    
    if (@{$h->{error}||[]}){
        $h->{group} = '';
        $h->{rec} = [];
        return $h;
    }

    for my $rec (@{$h->{rec}//[]}) {
        for my $f (qw/cid pid bid/) {
            $rec->{$f} = 0 unless is_valid_id($rec->{$f});
        }
    }
    
    return $h;
}

1;

