package DScribe::Parser::ppclog_api;

use Time::Local;
use JSON;
use Yandex::Validate qw/is_valid_id/;
use Yandex::HashUtils qw/hash_map hash_merge/;
use Yandex::ListUtils qw/as_array/;
use List::MoreUtils qw/uniq/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2 

Опции именованные:
    group_by => 'month' ( не используется )

{
    error => ["", "",],
    group => "12345",
    rec => [ {...}, {} ],
}

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    my $h = $line =~ /^</ ? $self->parse_syslog_json_line($line) : $self->parse_datetime_json_line($line);

    # Если при разборе строки ошибки -- ничего разумного не пытаемся делать
    if (@{$h->{error}||[]}){
        $h->{group} = '';
        $h->{rec} = [];
        return $h;
    }

    if ( !@{$h->{rec}} ){
        $h->{group} = '';
        return $h;
    }

    for my $rec ( @{$h->{rec}||[]} ){
        my $data = delete $rec->{data};
        my $api_values = eval { $self->api_get_param_values($data, $data->{param}); };
        if ($@) {
            push @{$h->{error}}, $@."\n".$self->json->encode([$data->{cmd}, $data->{param}]);
            %$rec = ();
            next;
        }
        $api_values = hash_map { [ uniq grep { is_valid_id($_) } @$_ ] } $api_values;
        hash_merge $data, $api_values;
        if (!defined $data->{param}) {
            $data->{param} = "null";
        } elsif (ref $data->{param}) {
            eval { 
                $data->{param} = $self->json->encode($data->{param});
            };
        }
        $data->{fulltime} ||= 0;
        $data->{response_ids} //= [];
        $data->{response} = $self->json->encode($data->{response});
        hash_merge $rec, $data;
    }

    if (@{$h->{error}}) {
        $h->{rec} = [ grep { keys %$_ } @{$h->{rec}} ];
    }
    
    return $h;
}

sub api_get_param_values
{
    my ($self, $row, $param) = @_;
    my $res = { cid => [], };
    $res->{cluid} = as_array(split /,/, ($row->{cluid}//''));
    return $res unless $row->{cmd};
    if ($row->{cmd} eq 'GetBalance') {
        push @{$res->{cid}}, @{as_array($param)};
        return $res;
    }
    if ($row->{cmd} =~ /TransferMoney/) {
        push @{$res->{cid}}, map { $_->{CampaignID} } @{as_array($param->{FromCampaigns})}, @{as_array($param->{ToCampaigns})};
    }
    if ($row->{cmd} =~ /PayCampaigns/) {
        push @{$res->{cid}}, map { $_->{CampaignID} } @{as_array($param->{Payments})};
    }
    if ($row->{cmd} =~ /^(GetClientInfo|GetClientsUnits|GetCampaignsList|GetForecastList|GetWordstatReportList|GetReportList)$/) {
        return $res;
    }
    my $names = {
        CampaignID  => 'cid',
        CampaignIDS => 'cid',
    };
    $param = as_array($param);
    for my $p (@$param) {
        next unless defined $p;
        if (ref $p ne 'HASH') {
            next;
        }
        for my $k (keys %$names) {
            if ($p->{$k}) {
                push @{$res->{$names->{$k}}}, @{as_array($p->{$k})};
            }
        }
    }
    push @{$res->{cid}}, @{as_array($row->{cid})};
    return $res;
}


1;


