package DScribe::Parser::ppclog_cmd;

use Time::Local;
use JSON;
use Yandex::Validate qw/is_valid_id/;
use Yandex::HashUtils qw/hash_map hash_merge/;
use Yandex::ListUtils qw/as_array/;
use List::MoreUtils qw/uniq/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2 

Опции именованные:
    group_by => 'month' ( не используется )

{
    error => ["", "",],
    group => "12345",
    rec => [ {...}, {} ],
}

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    my $h = $line =~ /<\d+/ 
        ? $self->parse_syslog_json_line($line)
        : $self->parse_datetime_json_line($line);

    # Если при разборе строки ошибки -- ничего разумного не пытаемся делать
    if (@{$h->{error}||[]}){
        $h->{group} = '';
        $h->{rec} = [];
        return $h;
    }

    if ( !@{$h->{rec}} ){
        $h->{group} = '';
        return $h;
    }

    for my $rec ( @{$h->{rec}||[]} ){
        my $data = delete $rec->{data};
        my $cmd_values = eval { $self->get_cmd_param_values($data, $data->{param}) };
        if ($@) {
            push @{$h->{error}}, $@."\n".$self->json->encode([$data->{cmd}, $data->{param}]);
            %$rec = ();
            next;
        }
        hash_merge $data, $cmd_values;
        $data->{$_} = [ uniq grep { is_valid_id($_) } @{as_array($data->{$_})} ] for qw/cid bid pid cluid client_id/;
        $data->{param} = eval { $self->json->encode($data->{param}) };
        if (!defined $data->{trace_id}) {
            $data->{trace_id} = $data->{reqid};
        }
        _fix_null_fields($data);
        hash_merge $rec, $data;
    }
    
    return $h;
}

sub get_cmd_param_values
{
    my ($self, $data, $param) = @_;
    my $res = { bid => [], cid => [], pid => [] };
    my %param2name = ( bid => 'bid', bids => 'bid', cid => 'cid', cids => 'cid', pid => 'pid', pids => 'pid' );
    for my $p (keys %param2name) {
        push @{ $res->{$param2name{$p}} }, split /\s*,\s*/, ($param->{$p}//'');
    }
    return $res;
}

sub _fix_null_fields
{
    my ($data) = @_;

    my @nullToZero = ('fulltime');
    for my $name (@nullToZero) {
        if (!defined $data->{$name}) {
            $data->{$name} = 0;
        }
    }
}

1;



