package DScribe::Parser::ppclog_java;

use Time::Local;
use JSON;
use Yandex::HashUtils qw/hash_merge/;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2

Базовый парсер для java логов в формате ppclog_cmd

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;

    # parse line
    my ($datetime_str, $json_string) = ($line =~ /(\d{4}-\d{2}-\d{2} \s+ \d{2}:\d{2}:\d{2}) \s+ (.*$)/x);
    unless ($json_string) {
        return {
            rec => [],
            error => [ "can't parse line ($line)" ],
        };
    }
    #parse datetime
    my ($datetime, $date) = DScribe::Parser::base_direct_log::_parse_datetime($datetime_str);
    unless ($datetime) {
        return {
            rec => [],
            error => [ "can't parse datetime '$datetime_str' ($line)" ],
        };
    }

    # parse json
    my $parsed_json = eval { $self->json->decode($json_string) };
    if ($@) {
        return {
            rec => [],
            error => [ "can't parse json data '$json_string' ($line)\n$@" ],
        };
    }

    _fix_null_fields($parsed_json);
    _fix_array_fields($parsed_json);
    $parsed_json->{param} = eval { $self->json->encode($parsed_json->{param}) };

    my $result_rec = {log_time => $datetime, log_date => $date};
    hash_merge $result_rec, $parsed_json;

    return {
        rec => [$result_rec],
        error => []
    };
}


sub _fix_null_fields
{
    my ($data) = @_;
    my %nullToArray = ( bids => 'bid', cids => 'cid', pids => 'pid');
    for my $p (keys %nullToArray) {
        $data->{$nullToArray{$p}} = defined $data->{$p} ? $data->{$p} : [];
    }

    my @nullToZero = ('uid', 'proc_id', 'fulltime');
    for my $name (@nullToZero) {
        if (! defined $data->{$name}) {
            $data->{$name} = 0;
        }
    }

    if (! defined $data->{role}) {
        $data->{role} = '';
    }

}

sub _fix_array_fields {
    my ($data) = @_;
    my @arrayFields = ('client_id', 'cluid');
    for my $name (@arrayFields) {
        if (defined $data->{$name} && ref($data->{$name}) eq 'ARRAY') {
            $data->{$name} = $data->{$name};
        } elsif (defined $data->{$name}) {
            $data->{$name} = [ $data->{$name} ];
        } else {
            $data->{$name} = [];
        }
    }
}

1;