package DScribe::Parser::ppclog_price;

use Mouse;

extends "DScribe::Parser::base_direct_log";

=head2 

=cut
sub parse_single_line
{
    my ($self, $line, %O) = @_;
    my $data = eval { $self->json->decode($line); };
    if (!$data) {
        return {
            rec => [],
            error => ["Can't parse line: $@"],
        };
    }
    my $rec_base = {
        service => $data->{service},
        method => $data->{method},
        reqid => int($data->{reqid}),

        log_date => [split / /, $data->{log_time}]->[0],
        log_time => $data->{log_time},

        uid => int($data->{uid}),
        host => $data->{log_hostname},
        ip => $data->{ip},
    };

    my @recs;
    for my $d (@{$data->{data}}) {
        push @recs, {
            %$rec_base,
            (map {$_ => $d->{$_} // ''} qw/type currency/),
            (map {$_ => int($d->{$_})} qw/cid pid bid id/),
            (map {$_ => 0+$d->{$_}} qw/price price_ctx/),
        };
    }
    return {
        rec => \@recs,
        error => [],
    };
}

1;




