package DScribe::Writer::Stderr;

=head1 

Отладочный модуль, не сохраняет данные, просто выводит их в STDERR

=cut

use Mouse;
use feature 'state';

use JSON;

use Log::Any qw/$log/;

has name => (
    is => 'ro',
    isa => 'Str',
    default => sub { 'Stderr' },
);



=head2 

    Пишет данные в соответствующие группировочные таблицы

    Параметры позиционные 
    $grouped_data -- ссылка на хеш { имя_группы => массив хешей }

=cut
sub write_grouped_data
{
    my ($self, $grouped_data) = @_; 

    for my $group (keys %$grouped_data){
        my $data_hashes = $grouped_data->{$group};
        next unless @$data_hashes;
        $self->write_single_group_data($group, $data_hashes);
    }

    return;
}


=head2 

    пишет данные в одну группировочную таблицу

    Параметры позиционные
    $group -- название группы (суффикс таблицы)
    $data -- ссылка на массив хешей

=cut
sub write_single_group_data
{
    my ($self, $group, $data) = @_;

    printf STDERR "line $group %d\n", length(to_json($data));

    # print STDERR to_json({ $group => $data });
}

1;
