#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Deep;
use Data::Dumper;

use DScribe::Parser::campaign_balance;

my $parser = DScribe::Parser::campaign_balance->new(name => "asdf");

my $expected_error = {
    group => '',
    rec => [], 
    error => [ignore()],
};

cmp_deeply($parser->parse_single_line(""), $expected_error);

my $expected = {
          'error' => [],
          'rec' => [
                     {
                       'log_date' => '2018-03-14',
                       'log_time' => '2018-03-14 18:04:20',

                       'service' => 'direct.intapi',
                       'method' => 'BalanceClient.NotifyOrder2',

                       'ip' => '95.108.173.169',
                       'reqid' => 1334524446159917076,
                       'host' => 'ppcdev6.yandex.ru',

                       cid => 18962591,
                       type => "wallet",
                       currency => "RUB",
                       ClientID => 9741369,
                       tid => 8991759615586,
                       sum => 369203_647_900,
                       sum_balance => 543_000,
                       sum_delta => 2_330_000
                     }
                   ]
};
cmp_deeply($parser->parse_single_line(qq!{"log_time":"2018-03-14 18:04:20","method":"BalanceClient.NotifyOrder2","service":"direct.intapi","ip":"95.108.173.169","reqid":1334524446159917076,"log_hostname":"ppcdev6.yandex.ru","log_type":"campaign_balance","data":{"cid":18962591,"type":"wallet","currency":"RUB","ClientID":9741369,"tid":8991759615586,"sum":369203.6479,"sum_balance":0.543,"sum_delta":2.33}}!), $expected);

done_testing;
