#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Deep;

use DScribe::Parser::dbshards_ids;

my @data = (
    [
        q!<134>1 2017-10-08T00:00:13+03:00 ci01f.yandex.net PPC.dbshards_ids.log 622385 - - 2017-10-08 00:00:13 {"insert_data":{"ClientID":"36065414","cid":null},"reqid":6431238805158722577,"cnt":"1","ids":["30680829"],"key":"cid"}!,
        {
            error => [],
            rec => [{
                host => 'ci01f.yandex.net',
                log_date => '2017-10-08',
                log_time => '2017-10-08 00:00:13',
                key => "cid",
                ids => [30680829],
                insert_data => q!{"ClientID":"36065414","cid":null}!,
                reqid => 6431238805158722577,
                cnt => 1,
            }]
        }
    ], [
        q!<134>1 2019-01-22T13:09:59+03:00 ppcdev6.yandex.ru PPC.dbshards_ids.log 960818 - - {"cnt":"1","reqid":5110449840227232890,"insert_data":{"cid":null,"ClientID":"352749"},"host":"ppcdev6.yandex.ru","key":"cid","ids":["51381583"],"log_time":"2019-01-22:13:09:59"}!,
        {
            error => [],
            rec => [{
                host => 'ppcdev6.yandex.ru',
                log_date => '2019-01-22',
                log_time => '2019-01-22 13:09:59',
                key => "cid",
                ids => [51381583],
                insert_data => q!{"ClientID":"352749","cid":null}!,
                reqid => 5110449840227232890,
                cnt => 1,
            }]
        }
    ], [
        q!{"log_time":"2017-10-10:01:09:31","host":"192.168.1.38","reqid":114777015347663834,"key":"cid","ids":[111000536],"insert_data":{"ClientID":123}}!,
        {
            error => [],
            rec => [{
                host => '192.168.1.38',
                log_date => '2017-10-10',
                log_time => '2017-10-10 01:09:31',
                key => "cid",
                ids => [111000536],
                insert_data => '{"ClientID":123}',
                reqid => 114777015347663834,
                cnt => 1,
            }]
        }
    ],
);

Test::More::plan(tests => scalar(@data));

my $parser = DScribe::Parser::dbshards_ids->new(name => "test");

for my $test(@data) {
    cmp_deeply($parser->parse_single_line($test->[0]), $test->[1]);
}

