#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Deep;

use DScribe::Parser::messages;

my @data = (
    [
        q{<134>1 2016-07-22T15:24:38+03:00 ppcdev4.yandex.ru direct-production.messages 69085 - - 2016-07-22:18:42:00 direct.script/ppcMonitorYTResourceUsage,1314708194963030138:0:1314708194963030138 message},
        {
            error => [],
            rec => [{
                host => 'ppcdev4.yandex.ru',
                log_date => '2016-07-22',
                log_time => '2016-07-22 18:42:00',
                log_time_nanos => 0,                
                message => 'message',
                method => 'ppcMonitorYTResourceUsage',
                parent_id =>  0,
                service => 'direct.script',
                span_id => 1314708194963030138,
                trace_id => 1314708194963030138,
                prefix => '',
                class_name => '',
                log_level => '',
            }]
        }
    ], [
        q{<134>1 2016-07-22T15:24:39+03:00 ppcdev4.yandex.ru direct-production.messages 69085 - - 2016-07-22:18:42:01 ppcdev4.yandex.ru,direct.script/ppcMonitorYTResourceUsage,1314708194963030138:0:1314708194963030138 message},
        {
            error => [],
            rec => [{
                host => 'ppcdev4.yandex.ru',
                log_date => '2016-07-22',
                log_time => '2016-07-22 18:42:01',
                log_time_nanos => 0,
                message => 'message',
                method => 'ppcMonitorYTResourceUsage',
                parent_id =>  0,
                service => 'direct.script',
                span_id => 1314708194963030138,
                trace_id => 1314708194963030138,
                prefix => '',
                class_name => '',
                log_level => '',
            }]
        }
    ], [
        q{2016-07-22:18:43:00 ppcdev4.yandex.ru,direct.script/ppcMonitorYTResourceUsage,1314708194963030138:0:1314708194963030138 message},
        {
            error => [],
            rec => [{
                host => 'ppcdev4.yandex.ru',
                log_date => '2016-07-22',
                log_time => '2016-07-22 18:43:00',
                log_time_nanos => 0,
                message => 'message',
                method => 'ppcMonitorYTResourceUsage',
                parent_id =>  0,
                service => 'direct.script',
                span_id => 1314708194963030138,
                trace_id => 1314708194963030138,
                prefix => '',
                class_name => '',
                log_level => '',
            }]
        }
    ], [
        q{2016-07-22:18:40:00 ppcdev4.yandex.ru,direct.script/ppcMonitorYTResourceUsage,1314708194963030138:0:1314708194963030138#bulk ["first message","second_message", "third \"message\""]},
        {
            error => [],
            rec => [
                {
                    host => 'ppcdev4.yandex.ru',
                    log_date => '2016-07-22',
                    log_time => '2016-07-22 18:40:00',
                    log_time_nanos => 0,
                    message => 'first message',
                    method => 'ppcMonitorYTResourceUsage',
                    parent_id =>  0,
                    service => 'direct.script',
                    span_id => 1314708194963030138,
                    trace_id => 1314708194963030138,
                    prefix => '',
                    class_name => '',
                    log_level => '',
                }, {
                    host => 'ppcdev4.yandex.ru',
                    log_date => '2016-07-22',
                    log_time => '2016-07-22 18:40:00',
                    log_time_nanos => 0,
                    message => 'second_message',
                    method => 'ppcMonitorYTResourceUsage',
                    parent_id =>  0,
                    service => 'direct.script',
                    span_id => 1314708194963030138,
                    trace_id => 1314708194963030138,
                    prefix => '',
                    class_name => '',
                    log_level => '',
                }, {
                    host => 'ppcdev4.yandex.ru',
                    log_date => '2016-07-22',
                    log_time => '2016-07-22 18:40:00',
                    log_time_nanos => 0,
                    message => 'third "message"',
                    method => 'ppcMonitorYTResourceUsage',
                    parent_id =>  0,
                    service => 'direct.script',
                    span_id => 1314708194963030138,
                    trace_id => 1314708194963030138,
                    prefix => '',
                    class_name => '',
                    log_level => '',
                }
            ]
        }
    ], [
        q{2016-07-22:19:42:00 ppcdev4.yandex.ru,direct.script/ppcMonitorYTResourceUsage.bad_data,1314708194963030138:0:1314708194963030138#bulk [["TASK: [juggler_check check_db_schema.checked (aggregated check - admin)] ****** ","Responsible list didn't match, fix it at https://golem.yandex-team.ru/hostinfo.sbml?object=developer_checks.direct.yandex.ru: golem ['ppalex', 'lena-san'], playbook ['direct-admin', 'rivik', 'dspushkin', 'pe4kin']","ok: [localhost] => (item={'children': ['CGROUP%direct_ng_scripts_prod:check_db_schema.checked'], 'service': 'check_db_schema.checked', 'ttl': 90000}) => {","    \"changed\": false,","    \"diff\": {},","    \"host\": \"developer_checks.direct.yandex.ru\",","    \"item\": {","        \"children\": [","            \"CGROUP%direct_ng_scripts_prod:check_db_schema.checked\"","        ],","        \"service\": \"check_db_schema.checked\",","        \"ttl\": 90000","    },","    \"service\": \"check_db_schema.checked\",","    \"todo_golem_resps\": []","}"]]},
        {
            error => [],
            rec => [{
                host => 'ppcdev4.yandex.ru',
                log_date => '2016-07-22',
                log_time => '2016-07-22 19:42:00',
                log_time_nanos => 0,
                message => q{["TASK: [juggler_check check_db_schema.checked (aggregated check - admin)] ****** ","Responsible list didn't match, fix it at https://golem.yandex-team.ru/hostinfo.sbml?object=developer_checks.direct.yandex.ru: golem ['ppalex', 'lena-san'], playbook ['direct-admin', 'rivik', 'dspushkin', 'pe4kin']","ok: [localhost] => (item={'children': ['CGROUP%direct_ng_scripts_prod:check_db_schema.checked'], 'service': 'check_db_schema.checked', 'ttl': 90000}) => {","    \"changed\": false,","    \"diff\": {},","    \"host\": \"developer_checks.direct.yandex.ru\",","    \"item\": {","        \"children\": [","            \"CGROUP%direct_ng_scripts_prod:check_db_schema.checked\"","        ],","        \"service\": \"check_db_schema.checked\",","        \"ttl\": 90000","    },","    \"service\": \"check_db_schema.checked\",","    \"todo_golem_resps\": []","}"]},
                method => 'ppcMonitorYTResourceUsage.bad_data',
                parent_id =>  0,
                service => 'direct.script',
                span_id => 1314708194963030138,
                trace_id => 1314708194963030138,
                prefix => '',
                class_name => '',
                log_level => '',
            }]
        }
    ], [
        q{2017-05-12:00:00:00 ppcdev-java-2.haze.yandex.net,direct.jobs/campaignlastchange.CampAggregatedLastchangeFeeder,4370699468929123824:0:4370699468929123824 [direct-job-pool_Worker-5] INFO  ru.yandex.direct.jobs.interceptors.JobLoggingInterceptor - START shard_7},
        {
            error => [],
            rec => [{
                log_date => '2017-05-12',
                log_time => '2017-05-12 00:00:00',
                log_time_nanos => 0,
                host => 'ppcdev-java-2.haze.yandex.net',
                service => 'direct.jobs',
                method => 'campaignlastchange.CampAggregatedLastchangeFeeder',
                span_id => 4370699468929123824,
                parent_id =>  0,
                trace_id => 4370699468929123824,
                prefix => 'direct-job-pool_Worker-5',
                log_level => 'INFO',
                class_name => 'ru.yandex.direct.jobs.interceptors.JobLoggingInterceptor',
                message => 'START shard_7',
            }]
        }
    ], [
        q{2017-05-14:04:13:55 ppcjava-api01g.da.yandex.ru,unknown/unknown,0:0:0 [metric-collector-00] INFO  ru.yandex.direct.metric.collector.MetricCollector - run metric provider ru.yandex.direct.libs.keywordutils.helper.ClemmerCache},
        {
            error => [],
            rec => [{
                log_date => '2017-05-14',
                log_time => '2017-05-14 04:13:55',
                log_time_nanos => 0,
                host => 'ppcjava-api01g.da.yandex.ru',
                service => 'unknown',
                method => 'unknown',
                span_id => 0,
                parent_id =>  0,
                trace_id => 0,
                prefix => 'metric-collector-00',
                log_level => 'INFO',
                class_name => 'ru.yandex.direct.metric.collector.MetricCollector',
                message => 'run metric provider ru.yandex.direct.libs.keywordutils.helper.ClemmerCache',
            }]
        }
    ], [
        q{2017-05-02:19:30:13 ppctest-java-01g.haze.yandex.net,unknown/unknown,0:0:0 [main] WARN  org.eclipse.jetty.server.handler.ContextHandler - Empty contextPath},
        {
            error => [],
            rec => [{
                log_date => '2017-05-02',
                log_time => '2017-05-02 19:30:13',
                log_time_nanos => 0,
                host => 'ppctest-java-01g.haze.yandex.net',
                service => 'unknown',
                method => 'unknown',
                span_id => 0,
                parent_id =>  0,
                trace_id => 0,
                prefix => 'main',
                log_level => 'WARN',
                class_name => 'org.eclipse.jetty.server.handler.ContextHandler',
                message => 'Empty contextPath',
            }]
        }
    ], [
        q{2017-04-01:01:21:30 ppctest-java-01g.haze.yandex.net,direct.jobs/monitoring.SwitchmanStatCollector,1385562170404766449:0:1385562170404766449 [direct-job-pool_Worker-12] ERROR org.apache.curator.ConnectionState - Connection timed out for connection string (ppctest-zookeeper-01i.haze.yandex.net:2181,ppctest-zookeeper-01g.haze.yandex.net:2181,ppctest-zookeeper-02i.haze.yandex.net:2181) and timeout (15000) / elapsed (36014) org.apache.curator.CuratorConnectionLossException: KeeperErrorCode = ConnectionLoss|    at org.apache.curator.ConnectionState.checkTimeouts(ConnectionState.java:197) ~[curator-client-2.8.0.jar:?]|        at org.apache.curator.ConnectionState.getZooKeeper(ConnectionState.java:87) ~[curator-client-2.8.0.jar:?]|      at org.apache.curator.CuratorZookeeperClient.getZooKeeper(CuratorZookeeperClient.java:115) ~[curator-client-2.8.0.jar:?]|   at org.apache.curator.framework.imps.CuratorFrameworkImpl.getZooKeeper(CuratorFrameworkImpl.java:477) ~[curator-framework-2.8.0.jar:?]| at org.apache.curator.framework.imps.GetChildrenBuilderImpl$3.call(GetChildrenBuilderImpl.java:214) ~[curator-framework-2.8.0.jar:?]|       at org.apache.curator.framework.imps.GetChildrenBuilderImpl$3.call(GetChildrenBuilderImpl.java:203) ~[curator-framework-2.8.0.jar:?]|       at org.apache.curator.RetryLoop.callWithRetry(RetryLoop.java:107) ~[curator-client-2.8.0.jar:?]|        at org.apache.curator.framework.imps.GetChildrenBuilderImpl.pathInForeground(GetChildrenBuilderImpl.java:200) ~[curator-framework-2.8.0.jar:?]|     at org.apache.curator.framework.imps.GetChildrenBuilderImpl.forPath(GetChildrenBuilderImpl.java:191) ~[curator-framework-2.8.0.jar:?]|      at org.apache.curator.framework.imps.GetChildrenBuilderImpl.forPath(GetChildrenBuilderImpl.java:38) ~[curator-framework-2.8.0.jar:?]|   at ru.yandex.direct.jobs.monitoring.SwitchmanStatCollector.execute(SwitchmanStatCollector.java:68) ~[yandex-direct-jobs.jar:?]|     at ru.yandex.direct.scheduler.support.BaseDirectJob.run(BaseDirectJob.java:90) ~[libs-scheduler.jar:?]|     at ru.yandex.direct.jobs.interceptors.JobLoggingInterceptor.lambda$wrap$5(JobLoggingInterceptor.java:33) ~[yandex-direct-jobs.jar:?]|   at ru.yandex.direct.jobs.interceptors.JobTracingInterceptor.lambda$wrap$4(JobTracingInterceptor.java:40) ~[yandex-direct-jobs.jar:?]|       at ru.yandex.direct.jobs.interceptors.JobJugglerMonitoringInterceptor.lambda$wrap$6(JobJugglerMonitoringInterceptor.java:40) ~[yandex-direct-jobs.jar:?]|   at ru.yandex.direct.scheduler.support.BaseDirectJob.execute(BaseDirectJob.java:77) [libs-scheduler.jar:?]|      at org.quartz.core.JobRunShell.run(JobRunShell.java:202) [quartz-2.2.3.jar:?]|      at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573) [quartz-2.2.3.jar:?]},
        {
            error => [],
            rec => [{
                log_date => '2017-04-01',
                log_time => '2017-04-01 01:21:30',
                log_time_nanos => 0,
                host => 'ppctest-java-01g.haze.yandex.net',
                service => 'direct.jobs',
                method => 'monitoring.SwitchmanStatCollector',
                span_id => 1385562170404766449,
                parent_id =>  0,
                trace_id => 1385562170404766449,
                prefix => 'direct-job-pool_Worker-12',
                log_level => 'ERROR',
                class_name => 'org.apache.curator.ConnectionState',
                message => q{Connection timed out for connection string (ppctest-zookeeper-01i.haze.yandex.net:2181,ppctest-zookeeper-01g.haze.yandex.net:2181,ppctest-zookeeper-02i.haze.yandex.net:2181) and timeout (15000) / elapsed (36014) org.apache.curator.CuratorConnectionLossException: KeeperErrorCode = ConnectionLoss|    at org.apache.curator.ConnectionState.checkTimeouts(ConnectionState.java:197) ~[curator-client-2.8.0.jar:?]|        at org.apache.curator.ConnectionState.getZooKeeper(ConnectionState.java:87) ~[curator-client-2.8.0.jar:?]|      at org.apache.curator.CuratorZookeeperClient.getZooKeeper(CuratorZookeeperClient.java:115) ~[curator-client-2.8.0.jar:?]|   at org.apache.curator.framework.imps.CuratorFrameworkImpl.getZooKeeper(CuratorFrameworkImpl.java:477) ~[curator-framework-2.8.0.jar:?]| at org.apache.curator.framework.imps.GetChildrenBuilderImpl$3.call(GetChildrenBuilderImpl.java:214) ~[curator-framework-2.8.0.jar:?]|       at org.apache.curator.framework.imps.GetChildrenBuilderImpl$3.call(GetChildrenBuilderImpl.java:203) ~[curator-framework-2.8.0.jar:?]|       at org.apache.curator.RetryLoop.callWithRetry(RetryLoop.java:107) ~[curator-client-2.8.0.jar:?]|        at org.apache.curator.framework.imps.GetChildrenBuilderImpl.pathInForeground(GetChildrenBuilderImpl.java:200) ~[curator-framework-2.8.0.jar:?]|     at org.apache.curator.framework.imps.GetChildrenBuilderImpl.forPath(GetChildrenBuilderImpl.java:191) ~[curator-framework-2.8.0.jar:?]|      at org.apache.curator.framework.imps.GetChildrenBuilderImpl.forPath(GetChildrenBuilderImpl.java:38) ~[curator-framework-2.8.0.jar:?]|   at ru.yandex.direct.jobs.monitoring.SwitchmanStatCollector.execute(SwitchmanStatCollector.java:68) ~[yandex-direct-jobs.jar:?]|     at ru.yandex.direct.scheduler.support.BaseDirectJob.run(BaseDirectJob.java:90) ~[libs-scheduler.jar:?]|     at ru.yandex.direct.jobs.interceptors.JobLoggingInterceptor.lambda$wrap$5(JobLoggingInterceptor.java:33) ~[yandex-direct-jobs.jar:?]|   at ru.yandex.direct.jobs.interceptors.JobTracingInterceptor.lambda$wrap$4(JobTracingInterceptor.java:40) ~[yandex-direct-jobs.jar:?]|       at ru.yandex.direct.jobs.interceptors.JobJugglerMonitoringInterceptor.lambda$wrap$6(JobJugglerMonitoringInterceptor.java:40) ~[yandex-direct-jobs.jar:?]|   at ru.yandex.direct.scheduler.support.BaseDirectJob.execute(BaseDirectJob.java:77) [libs-scheduler.jar:?]|      at org.quartz.core.JobRunShell.run(JobRunShell.java:202) [quartz-2.2.3.jar:?]|      at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573) [quartz-2.2.3.jar:?]},
            }]
        }
    ], [
        q{2017-05-15:00:00:00 ppcscripts01e.yandex.ru,direct.script/ppcCampAutoPrice,1784921255206948681:0:1784921255206948681 [heavy1,shard_9] sleep for 10 seconds},
        {
            error => [],
            rec => [{
                log_date => '2017-05-15',
                log_time => '2017-05-15 00:00:00',
                log_time_nanos => 0,
                host => 'ppcscripts01e.yandex.ru',
                service => 'direct.script',
                method => 'ppcCampAutoPrice',
                span_id => 1784921255206948681,
                parent_id =>  0,
                trace_id => 1784921255206948681,
                prefix => 'heavy1,shard_9',
                log_level => '',
                class_name => '',
                message => 'sleep for 10 seconds',
            }]
        }
    ], [
        q{2017-05-15:00:00:00 ppcscripts01e.yandex.ru,direct.script/ppcCampAutoPrice,1784921255206948681:0:1784921255206948681 [] empty prefix},
        {
            error => [],
            rec => [{
                log_date => '2017-05-15',
                log_time => '2017-05-15 00:00:00',
                log_time_nanos => 0,
                host => 'ppcscripts01e.yandex.ru',
                service => 'direct.script',
                method => 'ppcCampAutoPrice',
                span_id => 1784921255206948681,
                parent_id =>  0,
                trace_id => 1784921255206948681,
                prefix => '',
                log_level => '',
                class_name => '',
                message => 'empty prefix',
            }]
        }
    ], [
        q{2017-05-15:00:00:00 ppcscripts01e.yandex.ru,direct.script/xxx,1784921255206948681:0:1784921255206948681 [shard 10][NDS, ClientID 33098849] data filtered, 0 was dropped},
        {
            error => [],
            rec => [{
                log_date => '2017-05-15',
                log_time => '2017-05-15 00:00:00',
                log_time_nanos => 0,
                host => 'ppcscripts01e.yandex.ru',
                service => 'direct.script',
                method => 'xxx',
                span_id => 1784921255206948681,
                parent_id =>  0,
                trace_id => 1784921255206948681,
                prefix => '',
                log_level => '',
                class_name => '',
                message => '[shard 10][NDS, ClientID 33098849] data filtered, 0 was dropped',
            }]
        }
    ], [
        q!2017-05-15:00:00:01 ppcjava-api02f.da.yandex.ru,direct.api5/keywordsresearch.hasSearchVolume,315620260899990118:0:315620260899990118 [qtp1250442005-143034] ERROR ru.yandex.direct.api.v5.entity.keywordsresearch.service.HasSearchVolumeDelegate - Internal errors [java.util.concurrent.ExecutionException: java.util.concurrent.TimeoutException: Request timeout to not-connected after 5000 ms, java.util.concurrent.ExecutionException: java.util.concurrent.TimeoutException: Request timeout to not-connected after 5000 ms] while processing request HasSearchVolumeInnerRequest{keywords:[jtc jtc jw0778, jtc jtcjw0778, jtc jtc +jw 0778, ва101 +2p 032a +c, ва1012p032ac, +ва 101 2 +p 032 +a +c, dekraft ва101 +2p 032a +c, dekraft ва1012p032ac, dekraft +ва 101 2 +p 032 +a, 11069dek 121913, 11069dek121913, 11069 dek 121913, 11069 dek121913, dekraft 11069dek 121913, dekraft 11069dek121913, dekraft 11069 dek 121913, ва101 +3p 040a +d, ва1013p040ad, +ва 101 3 +p 040 +a +d, dekraft ва101 +3p 040a +d, dekraft ва1013p040ad, dekraft +ва 101 3 +p 040 +a, 11130dek 121931, 11130dek121931, 11130 dek 121931, 11130 dek121931, dekraft 11130dek 121931, dekraft 11130dek121931, dekraft 11130 dek 121931, ва101 +3p 063a +d, ва1013p063ad, +ва 101 3 +p 063 +a +d, dekraft ва101 +3p 063a +d, dekraft ва1013p063ad, dekraft +ва 101 3 +p 063 +a, 11132dek 121934, 11132dek121934, 11132 dek 121934, 11132 dek121934, dekraft 11132dek 121934, dekraft 11132dek121934, dekraft 11132 dek 121934, ва201 +3p 080a +d, ва2013p080ad, +ва 201 3 +p 080 +a +d, dekraft ва201 +3p 080a +d, dekraft ва2013p080ad, dekraft +ва 201 3 +p 080 +a, 13020dek 121939, 13020dek121939, 13020 dek 121939, 13020 dek121939, dekraft 13020dek 121939, dekraft 13020dek121939, dekraft 13020 dek 121939, 41 05821, 4105821, kranzle 41 05821, kranzle 4105821, 41 05841, 4105841, kranzle 41 05841, kranzle 4105841, jtc 1526, jtc1526, jtc jtc 1526, jtc jtc1526, jtc 4865, jtc4865, jtc jtc 4865, jtc jtc4865, jtc 1510, jtc1510, jtc jtc 1510, jtc jtc1510, jtc 5703, jtc5703, jtc jtc 5703, jtc jtc5703, jtc 4345, jtc4345, jtc jtc 4345, jtc jtc4345, 627894000, metabo 627894000, метабо 627894000, вн102 +2п 63а, вн1022п63а, +вн 102 2 +п 63 +а, dekraft вн102 +2п 63а, dekraft вн1022п63а, dekraft +вн 102 2 +п 63 +а, 17007dek 131590, 17007dek131590, 17007 dek 131590, 17007 dek131590, dekraft 17007dek 131590, dekraft 17007dek131590, dekraft 17007 dek 131590, узо 03 +2п 16а 10ма 6ка +ac, узо032п16а10ма6каac, узо 03 2 +п 16 +а 10, dekraft узо 03 +2п 16а 10ма 6ка, dekraft узо032п16а10ма6каac, dekraft узо 03 2 +п 16 +а, 14050dek 1113153, 14050dek1113153, 14050 dek 1113153, 14050 dek1113153, dekraft 14050dek 1113153, dekraft 14050dek1113153, dekraft 14050 dek 1113153, узо 03 +2п 25а 30ма 6ка +ac, узо032п25а30ма6каac, узо 03 2 +п 25 +а 30, dekraft узо 03 +2п 25а 30ма 6ка, dekraft узо032п25а30ма6каac, dekraft узо 03 2 +п 25 +а, 14054dek 1113161, 14054dek1113161, 14054 dek 1113161, 14054 dek1113161, dekraft 14054dek 1113161, dekraft 14054dek1113161, dekraft 14054 dek 1113161, узо 03 +4п 32а 30ма 6ка +ac, узо034п32а30ма6каac, узо 03 4 +п 32 +а 30, dekraft узо 03 +4п 32а 30ма 6ка, dekraft узо034п32а30ма6каac, dekraft узо 03 4 +п 32 +а, 14079dek 1113196, 14079dek1113196, 14079 dek 1113196, 14079 dek1113196, dekraft 14079dek 1113196, dekraft 14079dek1113196, dekraft 14079 dek 1113196, 625207000, metabo 625207000, метабо 625207000, диф 101 +2п 16a 30ма 4 5ка, диф1012п16a30ма45каac45мод, диф 101 2 +п 16 +a 30, dekraft диф 101 +2п 16a 30ма 4, dekraft диф1012п16a30ма45каac45мод, dekraft диф 101 2 +п 16 +a, 15003dek 121961, 15003dek121961, 15003 dek 121961, 15003 dek121961, dekraft 15003dek 121961, dekraft 15003dek121961, dekraft 15003 dek 121961, диф 101 +2п 40a 30ма 4 5ка, диф1012п40a30ма45каac6мод, диф 101 2 +п 40 +a 30, dekraft диф 101 +2п 40a 30ма 4, dekraft диф1012п40a30ма45каac6мод, dekraft диф 101 2 +п 40 +a, 15007dek 121965, 15007dek121965, 15007 dek 121965, 15007 dek121965, dekraft 15007dek 121965, dekraft 15007dek121965, dekraft 15007 dek 121965, диф 101 +2п 50a 30ма 4 5ка, диф1012п50a30ма45каac6мод, диф 101 2 +п 50 +a 30, dekraft диф 101 +2п 50a 30ма 4, dekraft диф1012п50a30ма45каac6мод, dekraft диф 101 2 +п 50 +a, 15008dek 129970, 15008dek129970, 15008 dek 129970, 15008 dek129970, dekraft 15008dek 129970, dekraft 15008dek129970, dekraft 15008 dek 129970, диф 101 +4п 40a 30ма 4 5ка, диф1014п40a30ма45каac8мод, диф 101 4 +п 40 +a 30, dekraft диф 101 +4п 40a 30ма 4, dekraft диф1014п40a30ма45каac8мод, dekraft диф 101 4 +п 40 +a, 15024dek 121968, 15024dek121968, 15024 dek 121968, 15024 dek121968, dekraft 15024dek 121968, dekraft 15024dek121968, dekraft 15024 dek 121968, диф 101 +4п 60a 30ма 4 5ка, диф1014п60a30ма45каac8мод, диф 101 4 +п 60 +a 30, dekraft диф 101 +4п 60a 30ма 4, dekraft диф1014п60a30ма45каac8мод, dekraft диф 101 4 +п 60 +a, 15026dek 121969],regionIds:[225],fields:[KEYWORD, ALL_DEVICES, MOBILE_PHONES, TABLETS, DESKTOPS]}!,
        {
            error => [],
            rec => [{
                log_date => '2017-05-15',
                log_time => '2017-05-15 00:00:01',
                log_time_nanos => 0,
                host => 'ppcjava-api02f.da.yandex.ru',
                service => 'direct.api5',
                method => 'keywordsresearch.hasSearchVolume',
                span_id => 315620260899990118,
                parent_id =>  0,
                trace_id => 315620260899990118,
                prefix => 'qtp1250442005-143034',
                log_level => 'ERROR',
                class_name => 'ru.yandex.direct.api.v5.entity.keywordsresearch.service.HasSearchVolumeDelegate',
                message => q!Internal errors [java.util.concurrent.ExecutionException: java.util.concurrent.TimeoutException: Request timeout to not-connected after 5000 ms, java.util.concurrent.ExecutionException: java.util.concurrent.TimeoutException: Request timeout to not-connected after 5000 ms] while processing request HasSearchVolumeInnerRequest{keywords:[jtc jtc jw0778, jtc jtcjw0778, jtc jtc +jw 0778, ва101 +2p 032a +c, ва1012p032ac, +ва 101 2 +p 032 +a +c, dekraft ва101 +2p 032a +c, dekraft ва1012p032ac, dekraft +ва 101 2 +p 032 +a, 11069dek 121913, 11069dek121913, 11069 dek 121913, 11069 dek121913, dekraft 11069dek 121913, dekraft 11069dek121913, dekraft 11069 dek 121913, ва101 +3p 040a +d, ва1013p040ad, +ва 101 3 +p 040 +a +d, dekraft ва101 +3p 040a +d, dekraft ва1013p040ad, dekraft +ва 101 3 +p 040 +a, 11130dek 121931, 11130dek121931, 11130 dek 121931, 11130 dek121931, dekraft 11130dek 121931, dekraft 11130dek121931, dekraft 11130 dek 121931, ва101 +3p 063a +d, ва1013p063ad, +ва 101 3 +p 063 +a +d, dekraft ва101 +3p 063a +d, dekraft ва1013p063ad, dekraft +ва 101 3 +p 063 +a, 11132dek 121934, 11132dek121934, 11132 dek 121934, 11132 dek121934, dekraft 11132dek 121934, dekraft 11132dek121934, dekraft 11132 dek 121934, ва201 +3p 080a +d, ва2013p080ad, +ва 201 3 +p 080 +a +d, dekraft ва201 +3p 080a +d, dekraft ва2013p080ad, dekraft +ва 201 3 +p 080 +a, 13020dek 121939, 13020dek121939, 13020 dek 121939, 13020 dek121939, dekraft 13020dek 121939, dekraft 13020dek121939, dekraft 13020 dek 121939, 41 05821, 4105821, kranzle 41 05821, kranzle 4105821, 41 05841, 4105841, kranzle 41 05841, kranzle 4105841, jtc 1526, jtc1526, jtc jtc 1526, jtc jtc1526, jtc 4865, jtc4865, jtc jtc 4865, jtc jtc4865, jtc 1510, jtc1510, jtc jtc 1510, jtc jtc1510, jtc 5703, jtc5703, jtc jtc 5703, jtc jtc5703, jtc 4345, jtc4345, jtc jtc 4345, jtc jtc4345, 627894000, metabo 627894000, метабо 627894000, вн102 +2п 63а, вн1022п63а, +вн 102 2 +п 63 +а, dekraft вн102 +2п 63а, dekraft вн1022п63а, dekraft +вн 102 2 +п 63 +а, 17007dek 131590, 17007dek131590, 17007 dek 131590, 17007 dek131590, dekraft 17007dek 131590, dekraft 17007dek131590, dekraft 17007 dek 131590, узо 03 +2п 16а 10ма 6ка +ac, узо032п16а10ма6каac, узо 03 2 +п 16 +а 10, dekraft узо 03 +2п 16а 10ма 6ка, dekraft узо032п16а10ма6каac, dekraft узо 03 2 +п 16 +а, 14050dek 1113153, 14050dek1113153, 14050 dek 1113153, 14050 dek1113153, dekraft 14050dek 1113153, dekraft 14050dek1113153, dekraft 14050 dek 1113153, узо 03 +2п 25а 30ма 6ка +ac, узо032п25а30ма6каac, узо 03 2 +п 25 +а 30, dekraft узо 03 +2п 25а 30ма 6ка, dekraft узо032п25а30ма6каac, dekraft узо 03 2 +п 25 +а, 14054dek 1113161, 14054dek1113161, 14054 dek 1113161, 14054 dek1113161, dekraft 14054dek 1113161, dekraft 14054dek1113161, dekraft 14054 dek 1113161, узо 03 +4п 32а 30ма 6ка +ac, узо034п32а30ма6каac, узо 03 4 +п 32 +а 30, dekraft узо 03 +4п 32а 30ма 6ка, dekraft узо034п32а30ма6каac, dekraft узо 03 4 +п 32 +а, 14079dek 1113196, 14079dek1113196, 14079 dek 1113196, 14079 dek1113196, dekraft 14079dek 1113196, dekraft 14079dek1113196, dekraft 14079 dek 1113196, 625207000, metabo 625207000, метабо 625207000, диф 101 +2п 16a 30ма 4 5ка, диф1012п16a30ма45каac45мод, диф 101 2 +п 16 +a 30, dekraft диф 101 +2п 16a 30ма 4, dekraft диф1012п16a30ма45каac45мод, dekraft диф 101 2 +п 16 +a, 15003dek 121961, 15003dek121961, 15003 dek 121961, 15003 dek121961, dekraft 15003dek 121961, dekraft 15003dek121961, dekraft 15003 dek 121961, диф 101 +2п 40a 30ма 4 5ка, диф1012п40a30ма45каac6мод, диф 101 2 +п 40 +a 30, dekraft диф 101 +2п 40a 30ма 4, dekraft диф1012п40a30ма45каac6мод, dekraft диф 101 2 +п 40 +a, 15007dek 121965, 15007dek121965, 15007 dek 121965, 15007 dek121965, dekraft 15007dek 121965, dekraft 15007dek121965, dekraft 15007 dek 121965, диф 101 +2п 50a 30ма 4 5ка, диф1012п50a30ма45каac6мод, диф 101 2 +п 50 +a 30, dekraft диф 101 +2п 50a 30ма 4, dekraft диф1012п50a30ма45каac6мод, dekraft диф 101 2 +п 50 +a, 15008dek 129970, 15008dek129970, 15008 dek 129970, 15008 dek129970, dekraft 15008dek 129970, dekraft 15008dek129970, dekraft 15008 dek 129970, диф 101 +4п 40a 30ма 4 5ка, диф1014п40a30ма45каac8мод, диф 101 4 +п 40 +a 30, dekraft диф 101 +4п 40a 30ма 4, dekraft диф1014п40a30ма45каac8мод, dekraft диф 101 4 +п 40 +a, 15024dek 121968, 15024dek121968, 15024 dek 121968, 15024 dek121968, dekraft 15024dek 121968, dekraft 15024dek121968, dekraft 15024 dek 121968, диф 101 +4п 60a 30ма 4 5ка, диф1014п60a30ма45каac8мод, диф 101 4 +п 60 +a 30, dekraft диф 101 +4п 60a 30ма 4, dekraft диф1014п60a30ма45каac8мод, dekraft диф 101 4 +п 60 +a, 15026dek 121969],regionIds:[225],fields:[KEYWORD, ALL_DEVICES, MOBILE_PHONES, TABLETS, DESKTOPS]}!,
            }]
        }
    ], [
        q{2017-05-02:19:30:13 ppctest-java-01g.haze.yandex.net,unknown/unknown,0:0:0 [] WARN  org.eclipse.jetty.server.handler.ContextHandler - Empty thread name},
        {
            error => [],
            rec => [{
                log_date => '2017-05-02',
                log_time => '2017-05-02 19:30:13',
                log_time_nanos => 0,
                host => 'ppctest-java-01g.haze.yandex.net',
                service => 'unknown',
                method => 'unknown',
                span_id => 0,
                parent_id =>  0,
                trace_id => 0,
                prefix => '',
                log_level => 'WARN',
                class_name => 'org.eclipse.jetty.server.handler.ContextHandler',
                message => 'Empty thread name',
            }]
        }
    ], [
        q{2017-09-18:15:23:57 95.108.172.165-red.dhcp.yndx.net,unknown/unknown,0:0:0 [ansible-stdout] WARN  ru.yandex.direct.ansiblejuggler.AnsibleWrapper$OutConsumer -     "service": "jobs.WarnplaceCleaner.working.development",},
        {
            error => [],
            rec => [{
                log_date => '2017-09-18',
                log_time => '2017-09-18 15:23:57',
                log_time_nanos => 0,
                host => '95.108.172.165-red.dhcp.yndx.net',
                service => 'unknown',
                method => 'unknown',
                span_id => 0,
                parent_id =>  0,
                trace_id => 0,
                prefix => 'ansible-stdout',
                log_level => 'WARN',
                class_name => 'ru.yandex.direct.ansiblejuggler.AnsibleWrapper$OutConsumer',
                message => '    "service": "jobs.WarnplaceCleaner.working.development",',
            }]
        }
    ], [
        q{2017-09-18:15:23:57.012 95.108.172.165-red.dhcp.yndx.net,unknown/unknown,0:0:0 [ansible-stdout] WARN  ru.yandex.direct.ansiblejuggler.AnsibleWrapper$OutConsumer -     "service": "jobs.WarnplaceCleaner.working.development",},
        {
            error => [],
            rec => [{
                log_date => '2017-09-18',
                log_time => '2017-09-18 15:23:57',
                log_time_nanos => 12_000_000,
                host => '95.108.172.165-red.dhcp.yndx.net',
                service => 'unknown',
                method => 'unknown',
                span_id => 0,
                parent_id =>  0,
                trace_id => 0,
                prefix => 'ansible-stdout',
                log_level => 'WARN',
                class_name => 'ru.yandex.direct.ansiblejuggler.AnsibleWrapper$OutConsumer',
                message => '    "service": "jobs.WarnplaceCleaner.working.development",',
            }]
        }
    ],
);

my $parser = DScribe::Parser::messages->new(name => "test");

for my $test(@data) {
    cmp_deeply($parser->parse_single_line($test->[0]), $test->[1]);
}

is(DScribe::Parser::messages::_nanos(0), 0);
is(DScribe::Parser::messages::_nanos(100), 100000000);
is(DScribe::Parser::messages::_nanos("003456789111"), 3456789);
is(DScribe::Parser::messages::_nanos("123456789111"), 123456789);

done_testing();
