#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Deep;
use Data::Dumper;

use DScribe::Parser::ppclog_api;

my $parser = DScribe::Parser::ppclog_api->new(name => "asdf");

my $expected_error = {
    group => '',
    rec => [], 
    error => [ignore()],
};

cmp_deeply($parser->parse_single_line(""), $expected_error);

my $expected = {
          'error' => [],
          'rec' => [
                     {
                       'log_time' => '2016-10-31 18:27:19',
                       'cmd' => 'retargetinglists.add',
                       'response_ids' => [],
                       'fulltime' => 0,
                       'cid' => [],
                       'cluid' => [],
                       'response' => 'null',
                       'api_version' => 5,
                       'log_date' => '2016-10-31',
                       'param' => 'null',
                       'host' => 'ppcsoap01f.yandex.ru',
                     }
                   ]
};
cmp_deeply($parser->parse_single_line(qq!2016-10-31 18:27:19 {"api_version":5,"cmd":"retargetinglists.add","host":"ppcsoap01f.yandex.ru"}!), $expected);

cmp_deeply($parser->parse_single_line(qq!<134>1 2016-10-31T18:27:19+03:00 ppcsoap01f.yandex.ru PPCLOG.ppclog_api.log 890282 - - 2016-10-31 18:27:19 {"api_version":5,"cmd":"retargetinglists.add"}!), $expected);

{
    local $expected->{rec}->[0]->{param} = '{"x":2}';
    local $expected->{rec}->[0]->{cid} = [88700];
    cmp_deeply($parser->parse_single_line(qq!2016-10-31 18:27:19 {"api_version":5,"cmd":"retargetinglists.add","host":"ppcsoap01f.yandex.ru","cid":[88700],"param":"{\\"x\\":2}"}!), $expected,
               "param as string");
    cmp_deeply($parser->parse_single_line(qq!2016-10-31 18:27:19 {"api_version":5,"cmd":"retargetinglists.add","host":"ppcsoap01f.yandex.ru","cid":[88700],"param":{"x":2}}!), $expected,
               "param as object");
}

done_testing;
