#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use Test::Deep;

use DScribe::Parser::ppclog_cmd;

my @data = (
    [
        q!<134>1 2019-01-22T12:43:44+03:00 ppcdev6.yandex.ru PPCLOG.ppclog_cmd.log 832187 - - 2019-01-22 12:43:44 {"proc_id":832187,"param":{"cid":"59897031","new":"{\"is_autobudget\":0,\"is_net_stop\":0,\"net\":{\"name\":\"maximum_coverage\"},\"name\":\"different_places\",\"search\":{\"name\":\"default\"},\"_strategy_name_human\":{\"net_name\":\"Maximum possible audience coverage\",\"search_name\":\"Highest available position\"},\"is_search_stop\":0}","old":"{\"search\":{\"name\":\"default\"},\"name\":\"\",\"is_search_stop\":0,\"_strategy_name_human\":{\"search_name\":\"Highest available position\"},\"is_autobudget\":0,\"net\":{\"name\":\"default\"},\"is_net_stop\":0}"},"bid":0,"host":"ppcdev6.yandex.ru","yandexuid":0,"cid":"59897031","reqid":5108716657874520720,"logtime":"20190122124344","cmd":"_save_strategy","role":null,"cpu_user_time":0,"uid":"415653817","runtime":0,"ip":"2a02:6b8:c0c:2eac:0:1406:6adc:1389","http_status":0,"pid":0,"cluid":"415653817","log_type":"cmd","service":"direct.perl.web"}!,
        {
            error => [],
            rec => [{
                       'bid' => [],
                       'http_status' => 0,
                       'logtime' => '20190122124344',
                       'fulltime' => 0,
                       'proc_id' => 832187,
                       'cluid' => [
                                    '415653817'
                                  ],
                       'role' => undef,
                       'ip' => '2a02:6b8:c0c:2eac:0:1406:6adc:1389',
                       'cid' => [
                                  '59897031'
                                ],
                       'yandexuid' => 0,
                       'uid' => '415653817',
                       'reqid' => '5108716657874520720',
                       'pid' => [],
                       'param' => '{"cid":"59897031","new":"{\\"is_autobudget\\":0,\\"is_net_stop\\":0,\\"net\\":{\\"name\\":\\"maximum_coverage\\"},\\"name\\":\\"different_places\\",\\"search\\":{\\"name\\":\\"default\\"},\\"_strategy_name_human\\":{\\"net_name\\":\\"Maximum possible audience coverage\\",\\"search_name\\":\\"Highest available position\\"},\\"is_search_stop\\":0}","old":"{\\"search\\":{\\"name\\":\\"default\\"},\\"name\\":\\"\\",\\"is_search_stop\\":0,\\"_strategy_name_human\\":{\\"search_name\\":\\"Highest available position\\"},\\"is_autobudget\\":0,\\"net\\":{\\"name\\":\\"default\\"},\\"is_net_stop\\":0}"}',
                       'trace_id' => '5108716657874520720',
                       'service' => 'direct.perl.web',
                       'cpu_user_time' => 0,
                       'host' => 'ppcdev6.yandex.ru',
                       'runtime' => 0,
                       'log_time' => '2019-01-22 12:43:44',
                       'cmd' => '_save_strategy',
                       'log_date' => '2019-01-22',
                       'log_type' => 'cmd',
                       'client_id' => []
            }]
        }
    ], [
        q!2019-01-22 12:45:23 {"cid":"59897266","reqid":5108825454051386103,"yandexuid":0,"param":{"cid":"59897266","new":"{\"is_autobudget\":0,\"net\":{\"name\":\"maximum_coverage\"},\"is_net_stop\":0,\"search\":{\"name\":\"default\"},\"name\":\"different_places\",\"is_search_stop\":0,\"_strategy_name_human\":{\"net_name\":\"Maximum possible audience coverage\",\"search_name\":\"Highest available position\"}}","old":"{\"_strategy_name_human\":{\"search_name\":\"Highest available position\"},\"is_search_stop\":0,\"name\":\"\",\"search\":{\"name\":\"default\"},\"is_net_stop\":0,\"net\":{\"name\":\"default\"},\"is_autobudget\":0}"},"bid":0,"host":"ppcdev6.yandex.ru","proc_id":903220,"http_status":0,"pid":0,"log_type":"cmd","cluid":"415653817","service":"direct.perl.web","uid":"415653817","runtime":0,"ip":"2a02:6b8:c00:1326:0:1406:73f9:a0f1","cpu_user_time":0,"logtime":"20190122124523","cmd":"_save_strategy","role":null}!,
        {
            error => [],
            rec => [{
                       'cmd' => '_save_strategy',
                       'bid' => [],
                       'service' => 'direct.perl.web',
                       'param' => '{"cid":"59897266","new":"{\\"is_autobudget\\":0,\\"net\\":{\\"name\\":\\"maximum_coverage\\"},\\"is_net_stop\\":0,\\"search\\":{\\"name\\":\\"default\\"},\\"name\\":\\"different_places\\",\\"is_search_stop\\":0,\\"_strategy_name_human\\":{\\"net_name\\":\\"Maximum possible audience coverage\\",\\"search_name\\":\\"Highest available position\\"}}","old":"{\\"_strategy_name_human\\":{\\"search_name\\":\\"Highest available position\\"},\\"is_search_stop\\":0,\\"name\\":\\"\\",\\"search\\":{\\"name\\":\\"default\\"},\\"is_net_stop\\":0,\\"net\\":{\\"name\\":\\"default\\"},\\"is_autobudget\\":0}"}',
                       'cid' => [
                                  '59897266'
                                ],
                       'pid' => [],
                       'log_time' => '2019-01-22 12:45:23',
                       'cluid' => [
                                    '415653817'
                                  ],
                       'fulltime' => 0,
                       'runtime' => 0,
                       'http_status' => 0,
                       'cpu_user_time' => 0,
                       'reqid' => '5108825454051386103',
                       'log_date' => '2019-01-22',
                       'logtime' => '20190122124523',
                       'role' => undef,
                       'log_type' => 'cmd',
                       'uid' => '415653817',
                       'ip' => '2a02:6b8:c00:1326:0:1406:73f9:a0f1',
                       'client_id' => [],
                       'host' => 'ppcdev6.yandex.ru',
                       'proc_id' => 903220,
                       'trace_id' => '5108825454051386103',
                       'yandexuid' => 0
            }]
        }
    ],
);

my $parser = DScribe::Parser::ppclog_cmd->new(name => "test");

for my $test(@data) {
    cmp_deeply($parser->parse_single_line($test->[0]), $test->[1]);
}

done_testing();
