package Dscribe::Controller::Index;
use Mojo::Base 'Mojolicious::Controller';

use utf8;

use lib::abs('../../../../lib');

use DScribe::Grep::Clickhouse::Direct;
use DScribe::Grep::Utils;

sub index
{
    my $self = shift;

    $self->stash(page => '', type => '');

    $self->stash(types => [ DScribe::Grep::Utils::list_known_tables() ]);
    $self->render();
}

sub type_params
{
    my $self = shift;
    my $type = ''.$self->req->url->path =~ s!\W!!gr;
        
    my @types = DScribe::Grep::Utils::list_known_tables();

    my $options = { map { $_ => DScribe::Grep::Clickhouse::Direct->new($_)->table->table_fields } @types };

    $self->stash(
        type => $type,
        types => \@types,
        page => 'type_params',
        options => $options,
        form => {},
    );

    $self->render(template => 'index/index');
}

sub search
{
    my $self = shift;
    $self->inactivity_timeout(5*60*60);
    my ($type) = ( $self->req->url->path =~ m!/(.+?)/search!);
    my %opt = map { $_ => $self->param($_) } grep { length $self->param($_) } @{$self->req->params->names};
    $opt{limit} //= 100;

    my $grep = DScribe::Grep::Clickhouse::Direct->new($type, %opt);
    
    my @types = DScribe::Grep::Utils::list_known_tables();

    my $options = { map { $_ => DScribe::Grep::Clickhouse::Direct->new($_)->table->table_fields } @types };

    for my $type_field (@{$options->{$type}}) {
        if ($type_field->{readable}) {
            if ($opt{$type_field->{name}.'_custom'} && !$opt{$type_field->{name}}) {
                $opt{$type_field->{name}} = $opt{$type_field->{name}.'_custom'};
            }
        }
    }

    $self->stash(
        type => $type,
        result => [],
        runtime => 0,
        fields => {},
        form => \%opt,
        types => \@types,
        page => 'search',
        options => $options,
        query => '',
    );

    if ($opt{show_stat}) {
        $opt{stat} = 'log_date';
        $opt{print} = 0;
        eval { $grep->logs_stat(\%opt); };
        if ($@) {
            print STDERR $@;
            $self->stash(error => $@);
            return $self->render(template => 'index/index');
        }
        $self->stash(result => $grep->result, runtime => $grep->runtime);
        return $self->render(template => 'index/index');
    }

    $opt{cb} = sub {
        my $c = shift;
        $self->stash(result => $grep->result, runtime => $grep->runtime);
        $self->stash(fields => $grep->table->fields_hash);
        $self->stash(query => $grep->query);
        $self->render(template => 'index/index');
    };
    $self->render_later;
    $grep->grep_logs(\%opt);
}

sub env
{
    my $self = shift;
    my %opt = map { $_ => $self->param($_) } grep { length $self->param($_) }  $self->param;
    my $headers = $self->tx->req->headers();
    $self->render(json => {
        headers => $headers->to_hash(),
    });
    # $self->respond(json => {
    #     env => {
    #         options => \%opt,
    #         headers => \%headers
    #     }
    # });
}

1;

