#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Список разработчиков-бекендеров в Директе по службам,
для распределения дежурств aap-duty и zbp

Запускать без параметров

Что можно доделывать:
    - убирать/отмечать новеньких
    - убирать/отмечать рук-лей (кроме maxlog)
"""

import sys
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
import os
import re
import argparse
import requests
import json
import tempfile
import shutil
import subprocess
import urllib


ABC_API_URL = 'https://abc-back.yandex-team.ru/api/v4/'
STAFF_API_URL = 'https://staff-api.yandex-team.ru/v3/'
OAUTH_HEADER = {}

TEAMS = {
        'kuhtich': 'yandex_monetize_search_direct_interface_9733',
        'pavryabov': 'yandex_monetize_search_direct_interface_dep21745',
        'hrustyashko': 'yandex_monetize_search_direct_interface_dep01717',
        }

def list_department(teamlead_login):
    # https://staff-api.yandex-team.ru/v3/persons?_pretty=1&department_group.department.url=yandex_monetize_search_direct_interface_dep21745
    headers = OAUTH_HEADER
    dep_url = TEAMS[teamlead_login]
    url = STAFF_API_URL + 'persons?' + urllib.urlencode({
        #'department_group.department.url': dep_url,
        '_query': '(department_group.department.url=="%s" or department_group.ancestors.department.url=="%s")' % ( dep_url, dep_url ),
        '_fields': 'person.login,person.id',
        'official.is_dismissed': 'false',
        })
    resp = requests.get(url, headers=headers, timeout=5)
    resp.raise_for_status()
    resp = resp.json()
    logins = [ p['login'] for p in resp['result']]
    return sorted(logins)


def parse_args():
    global SVN_PATH

    parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter, description=__doc__)
    parser.add_argument('--abc-token-file', default="~/.abc-auth-token", dest='token_file', help='путь до oauth токена для abc')
    args = parser.parse_args()

    return args


def main():
    global OAUTH_HEADER
    args = parse_args()

    try:
        with open(os.path.expanduser(args.token_file), 'r') as fh:
            OAUTH_HEADER = {'Authorization': 'OAuth ' + fh.read().strip()}
    except:
        sys.exit("can't get oauth token")

    for tl in [ 'kuhtich', 'hrustyashko', 'pavryabov' ]:
        print "\n## %s\n%s" % (tl, "\n".join(list_department(tl)))
    return


if __name__ == '__main__':
    main()

