#!/usr/bin/env python
# -*- coding: utf-8 -*-

description = """
Выдать ачивку с уровнем 1:
bin/dt-manage-achievement.py -a direct-app-duty -c 1 -l ssdmitriev give

прочитать текущее состояние ачивки:
bin/dt-manage-achievement.py -a direct-app-duty -l lena-san get
отозвать ачивку:
bin/dt-manage-achievement.py -a direct-app-duty -l lena-san revoke
восстановить отозванную ачивку:
bin/dt-manage-achievement.py -a direct-app-duty -l lena-san recover
поменять уровень ачивки на 2, а потом снова на 1:
bin/dt-manage-achievement.py -a direct-app-duty -l lena-san give -c 2
bin/dt-manage-achievement.py -a direct-app-duty -l lena-san give -c 1


+ проверять, есть ли у человека уже ачивка
+ уметь обновлять уровень ачивки
+ уметь отбирать ачивку
"""

import sys
sys.path.insert(0, '/opt/direct-py/startrek-python-client-sni-fix')
import datetime
from collections import defaultdict
import os
import re
import argparse
import requests
import json
import tempfile
import shutil
import subprocess
import urllib


ACHIEVEMENTS = {
        'direct-app-duty': 3110,
        'ex-direct-app-duty': 3111,
        'direct-dev-docs': 2609,
        }

ACHIEVERY_API_URL = 'https://staff.yandex-team.ru/api/achievery'
ACHIVEMENT_URL_TEMPLATE = 'https://staff.yandex-team.ru/achievements/achievement/%s'
OAUTH_HEADER = {}


def give_achievement( login, achievement_id, level):
    """
    выдать ачивку (когда ее еще не было)
    обновить уровень -- update_achievement
    восстановить отозванную -- update_achievement без уровня (None), см. recover
    """
    headers = OAUTH_HEADER
    url = ACHIEVERY_API_URL + '/given/?' + urllib.urlencode({
        #'_fields': 'is_active,person.login',
        })
    data = {
        'person.login': login,
        'achievement.id': achievement_id,
        'level': level,
        'is_active': True,
        }
    resp = requests.post(url, data=data, headers=headers, timeout=15)
    resp.raise_for_status()
    resp = resp.json()
    return


def update_achievement( aid, revision, level, is_active ):
    """
    обновить уровень или активность проверки ачивки

    aid -- id конкретного экземпляра ачивки (пользователь + ачивка)
    revision -- ревизия экземпляра ачивки
    """
    headers = OAUTH_HEADER
    url = ACHIEVERY_API_URL + '/given/' + urllib.quote(str(aid))
    data = {
        'level': level,
        'revision': revision,
        'is_active': is_active,
        }
    resp = requests.put(url, data=data, headers=headers, timeout=15)
    resp.raise_for_status()
    resp = resp.json()
    return


def get_achievement( login, achievement_id ):
    """
    прочитать данные ачивки из ачивницы
    """
    # https://staff.yandex-team.ru/api/achievery/given/?achievement.id=3110&person.login=pe4kin&_fields=achievement.category,achievement.title,is_active
    headers = OAUTH_HEADER
    url = ACHIEVERY_API_URL + '/given/?' + urllib.urlencode({
        '_fields': 'id,person.login,achievement.id,achievement.category,achievement.title,is_active,level,revision',
        })
    data = {
        'person.login': login,
        'achievement.id': achievement_id,
        }
    resp = requests.get(url, params=data, headers=headers, timeout=15)
    resp.raise_for_status()
    resp = resp.json()
    if resp['total'] > 0:
        res = {
                'id': resp['objects'][0]['id'],
                'achievement_id': resp['objects'][0]['achievement']['id'],
                'login': resp['objects'][0]['person']['login'],
                'is_active': resp['objects'][0]['is_active'],
                'level': resp['objects'][0]['level'],
                'revision': resp['objects'][0]['revision'],
                }
    return res



def parse_args():
    #parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter, description=__doc__)
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument("-h", "--help", dest="help", help="Справка", action="store_true")
    parser.add_argument('--abc-token-file', default="~/.abc-auth-token", dest='token_file', help='путь до oauth токена для abc')
    parser.add_argument("-l", "--login", dest="login", help="Логин", type=str)
    parser.add_argument("-c", "--count", dest="count", help="Уровень ачивки", type=int)
    parser.add_argument("-a", "--achievement", dest="achievement", help="Ачивки", type=str)
    opts, extra = parser.parse_known_args()

    if opts.help:
        print description
        print parser.format_help()
        exit(0)

    if len(extra) <= 0:
        exit("expecting action (list|get|give|revoke|recover)")

    opts.cmd = extra.pop(0)
    return opts


def main():
    global OAUTH_HEADER
    opts = parse_args()

    try:
        with open(os.path.expanduser(opts.token_file), 'r') as fh:
            OAUTH_HEADER = {'Authorization': 'OAuth ' + fh.read().strip()}
    except:
        sys.exit("can't get oauth token")


    if opts.cmd == "list":
        for a in sorted(ACHIEVEMENTS.keys()):
            url = ACHIVEMENT_URL_TEMPLATE % ACHIEVEMENTS[a]
            print "%s (%s) %s" % (a, ACHIEVEMENTS[a], url)
    elif opts.cmd == "give":
        if opts.count == None:
            exit("-c <level> expected, stop")
        badge_id = ACHIEVEMENTS[opts.achievement]
        achievement = get_achievement( opts.login, badge_id)
        if achievement != None:
            update_achievement( achievement['id'], achievement['revision'], opts.count, True )
        else:
            give_achievement( opts.login, badge_id, opts.count )
        achievement = get_achievement( opts.login, badge_id)
        print achievement
    elif opts.cmd == "get":
        badge_id = ACHIEVEMENTS[opts.achievement]
        achievement = get_achievement( opts.login, badge_id)
        print achievement
    elif opts.cmd == "revoke":
        badge_id = ACHIEVEMENTS[opts.achievement]
        achievement = get_achievement( opts.login, badge_id)
        if achievement != None:
            update_achievement( achievement['id'], achievement['revision'], None, False)
        achievement = get_achievement( opts.login, badge_id)
        print achievement
    elif opts.cmd == "recover":
        badge_id = ACHIEVEMENTS[opts.achievement]
        achievement = get_achievement( opts.login, badge_id)
        if achievement != None:
            update_achievement( achievement['id'], achievement['revision'], None, True)
        achievement = get_achievement( opts.login, badge_id)
        print achievement
    else:
        exit("unknown cmd '%s'" % opts.cmd)



if __name__ == '__main__':
    main()

