# INITIALIZATION. LOOK FOR #END to find profiles itself or for #DEFAULTS to find default variables
# declaring avaliable vars
declare -A net
declare -A size
declare -A fstype
declare -A fsopts
declare -A spare
declare -A shelf
declare -A raid
declare -A raidChunk
declare -A raidParity10
declare -A ignoreSSD
declare -A ignoreHDD
declare -A needBackup
declare -A distroVersions
declare -A parted
declare -A bigRaid
declare ROOT_ON_LVM
declare KV
declare SFV
declare KPKG
declare REINSTALL
#//INITIALIZATION

#DEFAULTS
#declare defaults
distro="trusty"                        # Distr version. Avaliable: precise, lucid, hardy
net["ipv4"]=0                           # Generate IPv4 in /etc/network/inetrfaces
net["ipv6"]=1                           # Generate IPv6 in /etc/network/interfaces

fstype["default"]="ext4"                # set default fs to EXT4
fsopts["default"]="noatime,nobarrier"   # Default mount options
raidParity10["default"]="f2"
ignoreSSD["default"]=0                  # ignoreSSD - if true, SSD will be excluded from partition creation.
ignoreHDD["default"]=0                  # ignoreHDD - if true, HDD will be excluded from partition creation.
raidChunk["default"]="512"              # Default chunk size
raid["default"]="auto"                  # 10 for 4 drives, 1 for 2 drives.
spare["default"]="0"                     # How many spare drives                 # TODO: test it
shelf["default"]="0"                     # Is partition should be on shelf
needBackup["default"]="0"                # Reserve 10% of disk (but no more then 100GB) for backups. Currently only avaliable for LVM partitions with size=grow. Though, no checks exists yet.
parted["default"]="auto"        # How many drives will be used in array. Maximum drives by default.
bigRaid["default"]="auto"       # Which raid level to use for 8 and more disks. raid["$mnt"] by default.
bcache=0
# kernel version
KV="4.4.68-33.3"
# search firmware version
SFV="20141009-4"

# Format: number:mount_point
#   Reserved names:
#      reserved - for grub reserve
#      swap     - for swap
#      lvm      - lvm, all other partitions will be created on lvm.
size["0:reserve"]="256M"                # For grub on GPT
size["1:/"]="50G"
size["2:/local"]="grow"
raid["0:reserve"]="1"                   # No need for raid10 for reserve partition
partitions="/ /local"
big_disk_dirs="var home opt tmp Berkanavt"
#//DEFAULTS

dist2ver["xenial"]="16.04"
dist2ver["trusty"]="14.04"
dist2ver["precise"]="12.04"
dist2ver["lucid"]="10.04"
dist2ver["hardy"]="8.04"
