# HELPER FUNCTIONS
is_ssd() { # Returns true if SSD, false if HDD
        local NAME
        local DISK
        local HDD
        NAME="${@}"

        echo ${NAME} | grep -q "^/dev" || NAME="/dev/${NAME}"

        DISK="$(readlink "${NAME}")"
        [ -z "${DISK}" ] && DISK="${NAME}"
        DISK=${DISK/\/dev\//}

        HDD="$(cat "/sys/block/${DISK}/queue/rotational" 2>/dev/null)"
        [ -z "${HDD}" ] && i-fail "Can't detect if device is SSD or not"

        return ${HDD}
}

# Sort keys of hash. Bash hasn't got built-in function for that
sk() {
        echo "$@" | tr ' ' '\n' | sort | tr '\n' ' '
}

execute_profile() {
        local stage
        for stage in ${stages}; do
                echo "Will execute stage ${stage}"
                $stage
        done
}

#//HELPER FUNCTIONS
