# create_md() - create raid.
create_md() { # -m -- mount point, -n -- raid name, ex. md1, md3, ...
        echo "Got: $@"
        local NUM
        local MP
        local SHELF
        local OPTIND
        local OPTARG
        local DRIVES
        local USEFUL_DRIVES=0
        local TOTAL_DRIVES=0
        local SIZE
        local CHUNK
        local INT_NUM
        local RAID_NAME
        local RAID_OPTS
        local JOURNAL_SIZE
        local IGNORE_SSD
        local VG_NUM
        local DRIVE_PART
        local RAID_LEVEL
        local CLEAN

        while getopts ":n:m:s:v:p:" opt; do
                echo "opt is $opt"
                case "${opt}" in
                        m)
                        MP="$OPTARG"
                        echo "MOUNT POINT: $LEVEL"
                        ;;
                        n)
                        NUM="$OPTARG"
                        echo "NUM: $NUM"
                        ;;
                        v)
                        VG_NUM="$OPTARG"
                        echo "VG_NUM: ${VG_NUM}. arg was $OPTARG"
                        ;;
                        s)
                        SHELF="${OPTARG}"
                        echo "SHELF: $SHELF"
                        ;;
                        p)
                        DRIVE_PART="${OPTARG}"
                        echo "DRIVE_PART: $DRIVE_PART"
                        ;;
                esac
        done

        CHUNK=${raidChunk["${MP}"]}
        INT_NUM=$(echo ${MP} | cut -d':' -f 1)
        RAID_NAME=$(echo ${MP} | cut -d':' -f 2)
        RAID_NAME="${RAID_NAME/\//}"
        RAID_NAME=${RAID_NAME:-root}
        RAID_LEVEL=${raid["${MP}"]}
        RAID_OPTS=""
        IGNORE_SSD=${ignoreSSD["${MP}"]}
        IGNORE_SSD=${IGNORE_SSD:-0}
        IGNORE_HDD=${ignoreHDD["${MP}"]}
        IGNORE_HDD=${IGNORE_HDD:-0}

        if [[ ${size[${MP}]} == "grow" ]]; then
                SIZE="--grow"
        else
                SIZE="--size ${size[${MP}]}"
        fi

        # https://raid.wiki.kernel.org/index.php/Initial_Array_Creation
        # Если raid5 или raid6, не используем --assume-clean
        if [ "$RAID_LEVEL" -eq 5 -o "$RAID_LEVEL" -eq 6 ]; then
            CLEAN=""
        else
            CLEAN="-- --assume-clean"
        fi

        # Сначала размечаем диски
        echo "Using MP=${MP}, NUM=$NUM"
        if [ "${shelf[${MP}]}" -eq 1 ]; then
            if [ $DRIVE_PART == "auto" ]; then
                for i in $(ls /dev/das:* | grep "das:[0-9]\+$"); do
                        if [ ${IGNORE_SSD} -ne 0 ]; then
                                is_ssd ${i} && continue
                        fi
                        part raid.${TOTAL_DRIVES}${INT_NUM} -l ${RAID_NAME} -d ${i/\/dev\//} ${SIZE} -a 16384
                        DRIVES="${DRIVES} raid.${TOTAL_DRIVES}${INT_NUM}"
                        [ $RAID_NAME == "reserve" ] && parted -s ${i} -- set 1 bios_grub on # Set bios_grub flag, if it's reserve partition
                        TOTAL_DRIVES=$((TOTAL_DRIVES+1))
                done
            else
                # Для полок с рейдами вида raid0 из нескольких raid5 сразу размечаем, собираем и выходим из функции
                total_drives=$(ls /dev/das:* | grep -c "das:[0-9]\+$")
                drives_per_disk=$((total_drives/DRIVE_PART))
                DNUM=0
                DRIVES=''
                RNUM=1
                RAIDS=''
                for i in $(ls /dev/das:* | grep "das:[0-9]\+$"); do
                    # Тут разметка
                    part raid.${DNUM}${INT_NUM}${RNUM} -l ${RAID_NAME} -d ${i/\/dev\//} ${SIZE} -a 16384
                    DRIVES="${DRIVES} raid.${DNUM}${INT_NUM}${RNUM}"
                    if [ $DNUM -lt $((drives_per_disk-1)) ]; then
                        DNUM=$((DNUM+1))
                    else
                        if [[ "${fstype["${MP}"]}" == "lvm" ]]; then
                            RAID_TYPE="pv"
                        else
                            RAID_TYPE="raid"
                        fi
                        # Тут сборка маленьких рейдов
                        raid $RAID_TYPE -d md${RNUM}${NUM} -l ${RAID_LEVEL} -e 1.2 --spares ${spare["${MP}"]}\
                            --name ${RAID_NAME} -a "${RAID_OPTS} --chunk=${CHUNK}" ${DRIVES} ${CLEAN}
                        RAIDS="${RAIDS} /dev/md${RNUM}${NUM}"
                        DNUM=0
                        DRIVES=''
                        RNUM=$((RNUM+1))
                    fi
                done
                # А тут сборка большого рейда или лвм
                if [[ "${fstype["${MP}"]}" == "lvm" ]]; then
                    volgroup vg${VG_NUM} ${RAIDS}
                else
                    raid "$(echo ${MP} | cut -d':' -f 2)" -d md${NUM} -l 0 -e 1.2 -a "${RAID_OPTS} --chunk=${CHUNK}" \
                        -o "${fsopts[${MP}]}" \
                        -m "-b 4096 -R stride=${STRIDE},stripe-width=${STRIPE_WIDTH} \
                        -j -J size=${JOURNAL_SIZE} -m 0 -O dir_index" \
                        --name ${RAID_NAME} -t ${fstype[${MP}]} ${RAIDS} \
                        -- --assume-clean
                fi
                return
            fi
        else
                # Если НЕ полка
                if [ $DRIVE_PART != "auto" ]; then
                    # Аналог вышестоящей секции для полок. Если мы собираем большой рейд из нескольких маленьких
                    total_drives=$(ls /dev/disk:* | wc -l)
                    drives_per_disk=$((total_drives/DRIVE_PART))
                    DNUM=0
                    DRIVES=''
                    RNUM=1
                    RAIDS=''
                    for i in $(ls /dev/disk:* | grep "disk:[0-9]\+$"); do
                        # Размечаем
                        part raid.${DNUM}${INT_NUM}${RNUM} -l ${RAID_NAME} -d ${i/\/dev\//} ${SIZE} -a 16384
                        DRIVES="${DRIVES} raid.${DNUM}${INT_NUM}${RNUM}"
                        if [ $DNUM -lt $((drives_per_disk-1)) ]; then
                            DNUM=$((DNUM+1))
                        else
                            if [[ "${fstype["${MP}"]}" == "lvm" ]]; then
                                RAID_TYPE="pv"
                            else
                                RAID_TYPE="raid"
                            fi
                            if [ $RAID_NAME != "reserve" ]; then
                                # Собираем маленькие
                                raid $RAID_TYPE -d md${RNUM}${NUM} -l ${RAID_LEVEL} -e 1.2 --spares ${spare["${MP}"]}\
                                    --name ${RAID_NAME} -a "${RAID_OPTS} --chunk=${CHUNK}" ${DRIVES} ${CLEAN}
                            fi
                            RAIDS="${RAIDS} /dev/md${RNUM}${NUM}"
                            DNUM=0
                            DRIVES=''
                            RNUM=$((RNUM+1))
                        fi
                        [ $RAID_NAME == "reserve" ] && parted -s ${i} -- set 1 bios_grub on
                    done
                    if [ $RAID_NAME != "reserve" ]; then
                        # Собираем большой
                        if [[ "${fstype["${MP}"]}" == "lvm" ]]; then
                            volgroup vg${VG_NUM} ${RAIDS}
                        else
                            raid "$(echo ${MP} | cut -d':' -f 2)" -d md${NUM} -l 0 -e 1.2 -a "${RAID_OPTS} --chunk=${CHUNK}" \
                                -o "${fsopts[${MP}]}" \
                                -m "-b 4096 -R stride=${STRIDE},stripe-width=${STRIPE_WIDTH} \
                                -j -J size=${JOURNAL_SIZE} -m 0 -O dir_index" \
                                --name ${RAID_NAME} -t ${fstype[${MP}]} ${RAIDS} \
                                -- --assume-clean
                        fi
                    fi
                    return
                fi

                # Теперь типовая разметка дисков
                for i in $(ls /dev/disk:* | grep "disk:[0-9]\+$"); do
                        if [ ${IGNORE_SSD} -ne 0 ]; then
                                is_ssd ${i} && continue
                        fi
                        if [ ${IGNORE_HDD} -ne 0 ]; then
                                is_ssd ${i} || continue
                        fi
                        if [ $RAID_NAME == "separate_disks" ]; then
                             # Каждый диск отдельную партишку будем монтировать в /opt/diskN
                             DNUM=1
                             RDNUM=0
                             echo ${DRIVES}
                             for disk in $(ls /dev/disk:* | grep "disk:[0-9]\+$"); do
                                   mkdir /opt/disk${DNUM}
                                   part /opt/disk${DNUM} -d disk:${RDNUM} -t ext4 ${SIZE} -a 2048 -o "${fsopts[${MP}]}"
                                   DNUM=$((DNUM+1))
                                   RDNUM=$((RDNUM+1)) 
                             done
                             return
                        fi
                        
                        if [ $RAID_NAME == "separate_ssd" ]; then
                           # Только sdc и sdd отдельную партишку будем монтировать в /opt/diskN
                           # При этом мы не проверяем, являются ли они ssd (FIX IT?)
                            DNUM=1
                            RDNUM=2
                            echo ${DRIVES}
                            for disk in sdc sdd; do
                                  mkdir /opt/disk${DNUM}
                                  part /opt/disk${DNUM} -d disk:${RDNUM} -t ext4 ${SIZE} -a 2048 -o "${fsopts[${MP}]}"
                                  DNUM=$((DNUM+1))
                                  RDNUM=$((RDNUM+1))
                            done
                            return
                        fi

            
                        if [ $RAID_NAME == "cache_device" ]; then
                             RDNUM=0
                             for disk in $(ls /dev/disk:* | grep "disk:[0-9]\+$"); do
                                is_ssd $disk && part raid.${RDNUM}${INT_NUM} -d disk:${RDNUM} -a 2048 --grow
                                RDNUM=$((RDNUM+1))
                             done
                             raid raid -d md${NUM} -l 1 -e 1.2 --spares ${spare["${MP}"]} --name ${RAID_NAME} -a "${RAID_OPTS}" raid.2${NUM} raid.3${NUM} -- --assume-clean
                             return
                          fi
              
                          if [ $RAID_NAME == "ssd_opt" ]; then
                             MP_NAME=$(echo ${MP} | cut -d':' -f 3)
                             if [[ -z $MP_NAME ]];then
                                 MP_NAME="/opt"
                             fi
                             RDNUM=0
                             for disk in $(ls /dev/disk:* | grep "disk:[0-9]\+$"); do
                                 is_ssd $disk && part raid.${RDNUM}${INT_NUM} -d disk:${RDNUM} -a 2048 --grow
                                 RDNUM=$((RDNUM+1))
                             done
                             raid "$MP_NAME" -d md${NUM} -l ${RAID_LEVEL} -e 1.2 -t ${fstype["${MP}"]} -o "${fsopts[${MP}]}" --name ${RAID_NAME} raid.2${NUM} raid.3${NUM} ${CLEAN}
                             return
                        fi
            
                        part raid.${TOTAL_DRIVES}${INT_NUM} -l ${RAID_NAME} -d ${i/\/dev\//} ${SIZE} -a 16384
                        DRIVES="${DRIVES} raid.${TOTAL_DRIVES}${INT_NUM}"
                        [ $RAID_NAME == "reserve" ] && parted -s ${i} -- set 1 bios_grub on
                        TOTAL_DRIVES=$((TOTAL_DRIVES+1))
                done
        fi

        [ ${TOTAL_DRIVES} -eq 0 ] && i-fail "Logic error: Total drives to install is 0! Check profile or settings"

        if [ $RAID_NAME == "reserve" ]; then
                return
        fi

        # Auto means: if there are 2-3 drives, it'll be raid1, if it is 4, 6, 8, ...- raid 10. 5, 7, 9, ... - raid 10 + 1 spare
        if [ "${raid[${MP}]}" == "auto" ]; then
                if [ $TOTAL_DRIVES -le 3 ]; then
                        raid[${MP}]=1
                else
                        raid[${MP}]=10
                        local drvs=$((TOTAL_DRIVES%2))
                        if [ $drvs -ne 0 ]; then
                                spare[${MP}]="1"
                        fi
                fi
        fi

        if [ $TOTAL_DRIVES -ge 8 -a "${bigRaid[${MP}]}" != "auto" ]; then
            raid[${MP}]="${bigRaid[${MP}]}"
        fi

        # Needed for stride
        case "${raid[${MP}]}" in
                0)
                        USEFUL_DRIVES=${TOTAL_DRIVES}
                ;;
                1)
                        USEFUL_DRIVES=1
                ;;
                5)
                        USEFUL_DRIVES=$((TOTAL_DRIVES-1))
                ;;
                6)
                        USEFUL_DRIVES=$((TOTAL_DRIVES-2))
                ;;
                10)
                        USEFUL_DRIVES=$((TOTAL_DRIVES/2))
                        RAID_OPTS="--parity=${raidParity10[${MP}]}"
                ;;
                default)
                        i-fail "unsupported raid level for mount point ${MP}: ${raid[${MP}]}"
                        ;;
        esac

        if [[ "${fstype["${MP}"]}" == "lvm" ]]; then
                raid pv -d md${NUM} -l ${raid["${MP}"]} -e 1.2 --spares ${spare["${MP}"]} --name ${RAID_NAME} -a "${RAID_OPTS} --chunk=${CHUNK}" ${DRIVES} ${CLEAN}
                volgroup vg${VG_NUM} md${NUM}
                return
        fi

        if [[ "${fstype["${MP}"]}" == "swap" ]]; then
                raid swap -d md${NUM} -l ${raid["${MP}"]} -e 1.2 --spares ${spare["${MP}"]} --name ${RAID_NAME} -a "${RAID_OPTS} --chunk=${CHUNK}" ${DRIVES} ${CLEAN}
                return
        fi

        if [[ "${fstype["${MP}"]}" == "without_fs" ]]; then
            raid raid -d md${NUM} -l ${raid["${MP}"]} -e 1.2 --spares ${spare["${MP}"]} --name ${RAID_NAME} -a "${RAID_OPTS} --chunk=${CHUNK}" ${DRIVES} ${CLEAN}
            return
        fi

        STRIDE=$((CHUNK/4))
        STRIPE_WIDTH=$((STRIDE*USEFUL_DRIVES))

        JOURNAL_SIZE="384"
        if [[ ${size[${MP}]} == *M ]]; then
                JOURNAL_SIZE="128"
        fi

        raid "$(echo ${MP} | cut -d':' -f 2)" -d md${NUM} -l ${raid[${MP}]} -e 1.2 --spares ${spare["${MP}"]} -a "${RAID_OPTS} --chunk=${CHUNK}" \
                -o "${fsopts[${MP}]}" -m "-b 4096 -R stride=${STRIDE},stripe-width=${STRIPE_WIDTH} -j -J size=${JOURNAL_SIZE} -m 0 -O dir_index" \
                --name ${RAID_NAME} -t ${fstype[${MP}]} ${DRIVES} ${CLEAN}
                                
        if [[ "$(echo ${MP} | cut -d':' -f 2)" == "/local" ]]; then
            for dir in $big_disk_dirs; do
                echo "${!size[*]}" | grep -q $dir || fstab -t "none" -o "bind" "/local/$dir" "/$dir"
            done
        fi

}
