create_lvm() { # -m -- mount point, -n -- lvm name, ex. md1, md3, ... -v -- vg number
        echo "Got: $@"
        local NUM
        local MP
        local SHELF
        local OPTIND
        local OPTARG
        local INT_NUM
        local LVM_NAME
        local SIZE
        local CHUNK
        local VG_NUM

        while getopts ":n:m:s:v:" opt; do
                echo "opt is $opt"
                case "${opt}" in
                        m)
                        MP="$OPTARG"
                        echo "MOUNT POINT: $LEVEL"
                        ;;
                        n)
                        NUM="$OPTARG"
                        echo "NUM: $NUM"
                        ;;
                        v)
                        VG_NUM="$OPTARG"
                        echo "VG_NUM: ${VG_NUM}. arg was $OPTARG"
                        ;;
                        s)
                        SHELF="$OPTARG"
                        echo "SHELF: $SHELF"
                        ;;
                esac
        done

        if [[ "${needBackup[${MP}]}" -eq "1" ]]; then
                echo "needBackup for ${MP}"
                local FREE_PE
                FREE_PE=$(lvm vgdisplay vg${VG_NUM} | grep "Free\s\+PE" | awk '{print $5}')
                SIZE=$((FREE_PE*4/1024))
                SIZE_NEW=$((FREE_PE*90/100*4/1024))
                DELTA=$((SIZE-SIZE_NEW))
                if [[ ${DELTA} -gt 100 ]]; then
                        DELTA=100
                fi
                size[${MP}]="$((SIZE-DELTA))G"
                echo "Size     : ${SIZE}"
                echo "Size_new : ${SIZE_NEW}"
                echo "Delta    : ${DELTA}"
                echo -n "sizeMP   : "; echo ${size[${MP}]}
        fi

        if [[ "${size[${MP}]}" == "grow" ]]; then
                SIZE="--grow"
        else
                SIZE="--size ${size[${MP}]}"
        fi

        INT_NUM=$(echo ${MP} | cut -d':' -f 1)
        LVM_NAME=$(echo ${MP} | cut -d':' -f 2)
        LVM_NAME="${LVM_NAME/\//}"
        [[ -z "${LVM_NAME}" ]] && ROOT_ON_LVM=1
        LVM_NAME=${LVM_NAME:-root}
        CHUNK=${raidChunk["${MP}"]}
        STRIDE=$((CHUNK/4))
        STRIPE_WIDTH=$((STRIDE*2))

        if [[ "${fstype["${MP}"]}" == "swap" ]]; then
                logvol swap -v vg${VG_NUM} --name "${LVM_NAME}"
                return
        fi

        logvol "$(echo ${MP} | cut -d':' -f 2)" \
                -v vg${VG_NUM} \
                --name "${LVM_NAME}" ${SIZE} \
                -o "${fsopts[${MP}]}" \
                -m "-b 4096 -R stride=${STRIDE},stripe-width=${STRIPE_WIDTH}
                -j \
                -J size=384 \
                -m 1 \
                -O dir_index" \
                -t ${fstype[${MP}]}
}
