#STAGES Functions and variables

create_partitions() {
        local NUM
        local create_func
        local LVM_NUM="-1"
        NUM=0
        create_func="create_md"
        # TODO: FIX THIS, IT's NOT WORKING
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                local LVM=0
                local DEV
                local MP
                local CHECK_OPTS
                # Mount partitions, if they are avaliable
                mkdir -p /target

                NUM=1
                for I in {125..129}; do
                        [ -f /dev/md${I} ] && ln -sf /dev/md${I} /dev/md${NUM}
                        NUM=$((NUM+1))
                done

                NUM=0
                mdadm --assemble --scan
                for I in $(sk ${!size[*]}); do
                        [[ "$I" == *reserve ]] && continue
                        [[ "$I" == *swap ]] && continue
                        [[ "$I" == *separate_disks ]] && continue
                        [[ "$I" == *separate_ssd ]] && continue
                        NUM=$(echo ${I} | cut -d':' -f 1)
                        if [[ "$I" == *lvm ]]; then
                                LVM=1
                                lvm lvchange -ay vg0
                                continue
                        fi

                        if [[ "${LVM}" == 1 ]]; then
                                LVM=1
                                LVM_NAME=$(echo ${I} | cut -d':' -f 2)
                                LVM_NAME=${LVM_NAME/\//}
                                
                                DEV="/dev/vg0/${LVM_NAME:-root}"
                                MP="/${LVM_NAME}"
                        else
                                DEV="/dev/md${NUM}"
                                MP="$(echo ${I} | cut -d':' -f 2)"
                        fi
                        for i in raid fstype fsopts needBackup raidChunk raidParity10 raid spare shelf ignoreSSD ignoreHDD parted bigRaid; do
                                eval $(echo $i["\$I"]=\${${i}["\$I"]:-\${$i["default"]}})
                        done

                        if [[ "${MP}" == "/" ]]; then
                                CHECK_OPTS="0 1"
                        else
                                CHECK_OPTS="0 0"
                        fi

                        fstab "${DEV}" "${MP}" -t "${fstype[${I}]}" -o "${fsopts[${I}]}"
                done

                h-mountall
                return
                fi
        fi
        REINSTALL=1

        clearpart --gpt --all

        # TODO: make this simplier
        for I in $(sk ${!size[*]}); do
                echo "Creating ${I}, ${NUM}"
                for i in raid fstype fsopts needBackup raidChunk raidParity10 raid spare shelf ignoreSSD ignoreHDD parted bigRaid; do
                        eval $(echo $i["\$I"]=\${${i}["\$I"]:-\${$i["default"]}})
                done
                [[ "${I}" = *swap ]] && fstype["$I"]="swap"
                [[ "${I}" = *lvm ]] && fstype["$I"]="lvm"

                echo "Creating md with m=${I}, n=${NUM}"
                [[ "$(echo ${I} | cut -d: -f 2)" == "lvm" ]] && LVM_NUM=$((LVM_NUM+1))

                if [[ ${create_func} == "create_lvm" ]]; then
                        if [[ "$(echo ${I} | cut -d: -f 2)" == "lvm" ]]; then
                create_md -m "${I}" -n "${NUM}" -v "${LVM_NUM}" -p ${parted["${I}"]}
                        else
                                create_lvm -m "${I}" -n "${NUM}" -v "${LVM_NUM}"
                        fi
                else
            create_md -m "${I}" -n "${NUM}" -v "${LVM_NUM}" -p ${parted["${I}"]}
                fi

                if [[ "$(echo ${I} | cut -d: -f 2)" == "lvm" ]]; then
                        create_func="create_lvm"
                fi
                NUM=$((NUM+1))
        done

        tag +${FUNCNAME}
}

deploy_rootfs() {
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                set-vendor ubuntu
                return
                fi
        fi
        REINSTALL=1

        OLD_SERVER=$SERVER
        export SERVER=ppcautoadmin.yandex.net
        if [ "${distro}" = "xenial" ]; then
                install p2p://ubuntu/16.04-x86_64
        elif [ "${distro}" = "trusty" ]; then
                install p2p://ubuntu/14.04-x86_64
        elif [ "${distro}" = "precise" ]; then
                install p2p://ubuntu/12.04-x86_64
        elif [ "${distro}" = "lucid" ]; then
                install p2p://ubuntu/10.04.3-x86_64
        elif [ "${distro}" = "hardy" ]; then
                install p2p://ubuntu/8.04.4-x86_64
        else
                i-fail "unsupported distro: $distro"
        fi
        export SERVER=$OLD_SERVER

        tag +${FUNCNAME}
}

deploy_kernel() {
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                return
                fi
        fi
        REINSTALL=1

        repo -l ${distro} mirror/ubuntu

        if   [ "${distro}" = "xenial" -o "${distro}" = "trusty" -o "${distro}" = "precise" ]; then
                # Use search kernel on trusty
                setup_bootloader
                repo dist/search-kernel stable/all/
                repo dist/search-kernel stable/amd64/
		repo dist/direct-common stable/amd64/
                packages linux-image-${KV} linux-headers-${KV} \
                        linux-tools=${KV} linux-firmware  initramfs-tools
                tag +${FUNCNAME}
                return
        elif [ "${distro}" = "lucid" ]; then
                # Use kernel from search-lucid, it's newer and stable
                KV="3.2.0-31-server"
                repo dist/search-lucid stable/all/
                repo dist/search-lucid stable/amd64/
        elif [ "${distro}" = "hardy" ]; then
                KV="2.6.31-14-server"
        else
                i-fail "unsupported distro: $distro"
        fi

        if [ -z "${KPKG}" ]; then
                packages linux-image-${KV}
        else
                packages ${KPKG} initramfs-tools
        fi

        tag +${FUNCNAME}
}

deploy_packages() {
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                return
                fi
        fi
        REINSTALL=1

        for dir in $big_disk_dirs; do
            echo "ensure /target/$dir"
            mkdir -p /target/$dir
        done

        # Some packages needs /etc/resolv.conf to be valid
        echo "domain yandex.ru" > /target/etc/resolv.conf
        echo "search yandex.ru" >> /target/etc/resolv.conf
        echo "nameserver ::1" >> /target/etc/resolv.conf
        echo "nameserver 2a02:6b8::1:1" >> /target/etc/resolv.conf

        repo --tmp dist/common stable/all/
        repo --tmp dist/common stable/amd64/
        repo --tmp dist/system configs/all/

        rm -f /target/bin/sh.distrib ||:
        rm -f /target/usr/share/man/man1/sh.distrib* ||:
        
        repo --tmp dist/yandex-${distro} stable/all/
        repo --tmp dist/yandex-${distro} stable/amd64/

        repo --tmp dist/direct-common stable/all/
        repo --tmp dist/direct-common stable/amd64/

        repo --tmp dist/direct-${distro} stable/all/
        repo --tmp dist/direct-${distro} stable/amd64/

        if [[ "$distro" = "precise" ]]; then
                packages upstart=1.5-0ubuntu5
        fi

        packages ssh rsync bind9 wget build-essential finger netcat tcpdump \
            psmisc irqbalance vim ethtool ntpdate ntp mailutils \
            strace less sudo file atop whois traceroute host screen multitail \
            smartmontools lsscsi sysstat lvm2 xfsprogs sdparm iotop mc mdadm \
            postfix python-apt \
            gdisk  -o DPkg::Options::='--force-confnew'

        if [ "${distro}" = "trusty" -o "${distro}" = "precise" ]; then
                packages yandex-du-ansible-pull
        fi

        password -u root --encrypted '$1$mIDHmZIj$ilGX/KoqBqHqv0XCoQMnW/'

        mkdir -p /target/root/.ssh
        cat > /target/root/.ssh/authorized_keys2 <<'EOF'
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDNZOFNwCzpxWDDEiHQdpfjjMY0PEBluJEmZdnkpe3E8TwkKL7te3IvNJNAcOCYmt9JioOuhoVeeKn40po1mFH4OOnqjKijR3JyfQ1lNDHIProR2yCR/wkBblDKlSIdl23ZGCLq5H3P0dohWloY5pr2PAu5eqY2bnxQWs4wGH9nTxjOCHNF1Ml49Rjxotz55aFZ+DqOwdXQHTBdNrGnskK7tKGzRSCqIhzMmd8NkGDpELbXI485IUQTln2gM4tkbZ/mEDT13F6b1wXBtyfx3oFmp5S8+OL5P0oskWRAengcX2zdmQlFAkJoFswVuusqHjQ2P86lcvVvFEa77W0mslwv dspushkin@yandex-team.ru
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCe+4t2CZWAhoxshj6J+SdJwTzbeePfoneTS4JI3iCbq9wYOJp0vkKuTNXP6V+ARnOTn+2oIeWsDXb1qcHiwlT9PDmbQApQP7AAS+yi095fQypNu8XunNEYP9fnq7LE3j1VQOScJ0S7ZAuSBEGctJSZnPcSIe19RwxBxwayXdDYlAqxCd6jKHhuFRucTHdMiPaQZrlg9lMPht9G9n4eqYxPbpk4vYm0pl2raBSUrA6qqoCP8EL47uzcFfjm66lIawylNWudMNANdOzOV0IiNNR0lWxO/6F0tGT3Wzqt+u7aXqAYMAndWo8y/xfwRG99VynMG/AbRa294CNSuMTFBgBP dspushkin@yandex-team.ru
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCwnPKcsut7RSi+oXQrHW3TqSCAl9LqF25r6i9RcBCuPdKZlxzKpVPI2R6IKSPfgmmVCRFbQ6n6zE3E7gZ9QYlGVxUNsKyHO5wrogVBxN2XzEbcXeT3LluqFoLVjtt1/OliGX15kyYzV1SXxavSDW35QJXadLxe55wrLeTSEZ9CKvJWv27+RwO2gjcy2xnVa4P8bAU4kdPeUANFCKNVMCpjhr7p+XbVumKH0hWAeyhpdUGO7qEPN6nRCOwIsa57rC5haxZFTTKApUFDLCaESyD1V4VffBrdo7/F2gj+YYROW4+dMrwP1GH+rks/QsLXbpOE+Rsxyzi9yHCozVWXEwQr pe4kin@84.201.172.174-red2.dhcp.yndx.net
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDzjL8xOya8wMS577d5iMW4xLurQwOfR2r8alNhAWFpFHG9icJgUllozhLZ10llCfEr5FZ37erEAFpShHpTR9u7UNqG3sLvLAaAOsl1dpLSP28jVtwiDaIrOlpHl5Hz7pJVxcwE9xRYsOPXtfG3ngeYje+rEXo1EA8YMtGhMhS1FM1KIUdtaobJaqH46ztnoB53QnYKjg1hPPQn33eAmMRq0I6hX0DYgfiT8lsFRMquSiufnbTrKy5Vyz2kcrnks3W1auFjq5Vxhu3/5inl7Yc7kcj2fr8NBAL0Gz3OIqsbY45PYVt3TXzvPawaTvvKwYEYCbrrbO9s5CzKeVkykhe7 rivik@bart
EOF
        chmod 0700 /target/root/.ssh
        chmod 0600 /target/root/.ssh/authorized_keys2
        chown root:root -R /target/root/.ssh

        tag +${FUNCNAME}

}

setup_network() {
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                return
                fi
        fi
        REINSTALL=1

        echo "domain yandex.ru" > /target/etc/resolv.conf
        echo "search yandex.ru" >> /target/etc/resolv.conf
        echo "nameserver ::1" >> /target/etc/resolv.conf
        if [[ "${net["ipv4"]}" == 1 && "${net["ipv6"]}" == 1 ]]; then
                network -4 -6 -s auto --mtu 8950
                resolv --search yandex.ru --search yandex.net --domain yandex.ru
                resolv --dns localhost --dns ks_net_router
                echo "nameserver 213.180.205.1" >> /target/etc/resolv.conf
        elif [[ "${net["ipv4"]}" == 1 && "${net["ipv6"]}" == 0 ]]; then
                network -4 -s auto --mtu 8950
                resolv --search yandex.ru --search yandex.net --domain yandex.ru
                resolv --dns localhost --dns ks_net_router
                echo "nameserver 213.180.205.1" >> /target/etc/resolv.conf
        elif [[ "${net["ipv4"]}" == 0 && "${net["ipv6"]}" == 1 ]]; then
                network -6 -s auto --mtu 8950
                resolv --search yandex.ru --search yandex.net --domain yandex.ru
#                resolv --dns localhost --dns ns1.yandex.net
                echo "nameserver 2a02:6b8::1:1" >> /target/etc/resolv.conf
        elif [[ "${net["ipv4"]}" == 0 && "${net["ipv6"]}" == 0 ]]; then
                echo "No configuration specified"
        fi

        tag +${FUNCNAME}
}

setup_bootloader() {
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                return
                fi
        fi
        REINSTALL=1

        if [[ "${distro}" == lucid || "${distro}" == "hardy" ]]; then
                repo local ubuntu hardy --tmp

        # Find /boot
        if [[ ${ROOT_ON_LVM} -ne 0 ]]; then
                for I in $(sk ${!size[*]}); do
                        [[ ${I} != *boot ]] && continue
                        echo "/dev/md$(echo "${I}" | cut -d: -f 1)" > /tmp/ks-root
                        ln -sf . /target/boot/boot
                        ROOT_ON_LVM=2
                        break
                done
                [[ ${ROOT_ON_LVM} -ne 2 ]] && i-fail "Can't find boot partition"
        fi

        elif [[ "${distro}" == "precise" ]]; then
                repo --tmp dist/direct-"${distro}" stable/all/
                repo --tmp dist/direct-"${distro}" stable/amd64/
                packages grub-pc=2.02~beta2-9ubuntu1.7yandex1
        elif [[ "${distro}" == "trusty" ]]; then
                repo --tmp dist/direct-"${distro}" stable/all/
                repo --tmp dist/direct-"${distro}" stable/amd64/
                packages grub-pc=2.02~beta2-9ya1 grub-pc-bin=2.02~beta2-9ya1 grub-common=2.02~beta2-9ya1 grub2-common=2.02~beta2-9ya1
        fi

        bootloader

        tag +${FUNCNAME}
}

setup_workarounds() {
        if tag ${FUNCNAME}?; then
                if [[ ${REINSTALL} -eq 0 ]]; then
                return
                fi
        fi
        REINSTALL=1

        # Disable quite mode for GRUB. Workaround, until fixed upstream
        sed -i "s/ro   quiet/ro libata.ignore_hpa=0 verbose --verbose/" /target/boot/grub/grub.cfg ||:

        awk 'BEGIN {found=0}{if ($0 ~ /30_os-prober/) {found = !found}; if (!found) {print $0}}' /target/boot/grub/grub.cfg > /target/boot/grub/grub.cfg.new ||:
        sed -i 's/\(GRUB_HIDDEN_TIMEOUT_QUIET\)=true/\1=false/g;s/\(GRUB_CMDLINE_LINUX_DEFAULT\)="quiet"/\1="libata.ignore_hpa=0 verbose"/g' /target/etc/default/grub
        echo "Europe/Moscow" > /target/etc/timezone
        echo "root: ppc-root@yandex-team.ru" >> /target/etc/aliases
        if [[ "$distro" = "precise" ]]; then
                if [ -w /target/etc/sudoers ]; then
                        sed -i 's/%sudo\tALL=(ALL:ALL) ALL/%sudo ALL=NOPASSWD: ALL/' /target/etc/sudoers
                fi
        fi
        #sed -i 's/nameserver\s+::1/namserver 127.0.0.1/g' /target/etc/resolv.conf

        #mdadm -D -s /etc/mdadm/mdadm.conf
        #sed -i 's/01.00/1.0/g' /etc/mdadm/mdadm.conf
        ntp ntp1.yandex.net ntp2.yandex.net ntp3.yandex.net ntp4.yandex.net

        # root can login with ssh keys only by default in trusty
        # but ansible-pull should fix it
        chroot /target /bin/sh <<'EOF'
dpkg-reconfigure openssh-server
locale-gen ru_RU.UTF-8
locale-gen en_US.UTF-8
ln -sf /usr/share/zoneinfo/Europe/Moscow /etc/localtime
EOF

        mv -f /target/boot/grub/grub.cfg.new /target/boot/grub/grub.cfg ||:

    mkdir -p /target/var/run/network ||:
#        cat /proc/mounts > /target/etc/mtab
        echo 'SUBSYSTEM=="block", ACTION=="add|change", ENV{ID_FS_TYPE}=="linux_raid_member", DEVPATH=="*/virtual/*", RUN+="/sbin/mdadm --incremental $tempnode"' > /target/lib/udev/rules.d/85-mdadm.rules
        echo 'SUBSYSTEM=="block", KERNEL=="md*", ACTION=="change", TEST=="md/stripe_cache_size", ATTR{md/stripe_cache_size}="4096"' > /target/lib/udev/rules.d/60-md-stripe-cache.rules
        sync
        tag +${FUNCNAME}
}

create_bcache() {
    if [[ bcache -eq 0 ]]; then
        return
    fi
    if [[ "$distro" = "trusty" ]]; then
        repo --tmp dist/yandex-trusty stable/amd64/
        packages bcache-tools
    fi
    modprobe bcache
    chroot /target /bin/bash <<'EOF'
    CACHE_DEVICE=$(mdadm -D -s |grep cache_device |awk '{print $2}')
    BACK_DEVICE=$(mdadm -D -s |grep back_device |awk '{print $2}')
    /usr/sbin/make-bcache -B $BACK_DEVICE -C $CACHE_DEVICE --wipe-bcache
    echo $BACK_DEVICE > /sys/fs/bcache/register
    echo $CACHE_DEVICE > /sys/fs/bcache/register
    sleep 3s
    mkfs.ext4 /dev/bcache0
    blkid -o export /dev/bcache0 > /tmp/blkid_bcache
    source /tmp/blkid_bcache
    if [ -z $UUID ];then echo "UUID is emtpty!"; exit 2; fi
    echo "UUID=${UUID} /opt ext4 noatime,nobarrier 0 1" >> /etc/fstab
EOF
}

# Set default stages and order.
ROOT_ON_LVM=0
REINSTALL=1

#stages="create_partitions deploy_rootfs deploy_kernel deploy_packages setup_network setup_bootloader setup_workarounds create_bcache"
stages="create_partitions deploy_rootfs deploy_kernel deploy_packages setup_network setup_bootloader setup_workarounds"
#//STAGES
